/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.umlgen.reverse.java.internal.ReversePlugin;
import org.eclipse.umlgen.reverse.java.internal.wizards.Java2UMLWizard;

public class UMLFromJavaAction
extends AbstractHandler {
    protected IJavaElement javaElement;
    private IWorkbenchWindow window;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = Display.getDefault().getActiveShell();
        try {
            Wizard wizard;
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object selectedObj = selection.getFirstElement();
                if (selectedObj instanceof IPackageFragment) {
                    this.javaElement = (IPackageFragment)selectedObj;
                } else if (selectedObj instanceof IJavaProject) {
                    this.javaElement = (IJavaProject)selectedObj;
                }
            }
            if ((wizard = this.createWizard()) instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(this.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.getInitialContainer()));
            }
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            this.postWizard(result);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    protected IContainer getInitialContainer() {
        IContainer container = null;
        if (this.javaElement != null) {
            try {
                container = (IContainer)this.javaElement.getCorrespondingResource();
            }
            catch (JavaModelException e) {
                ReversePlugin.log(e);
            }
        }
        return container;
    }

    protected IWorkbench getWorkbench() {
        return ReversePlugin.getDefault().getWorkbench();
    }

    protected Wizard createWizard() throws CoreException {
        Java2UMLWizard wizard = new Java2UMLWizard();
        wizard.setJavaElement(this.javaElement);
        return wizard;
    }

    protected boolean postWizard(int code) {
        return code == 0;
    }
}

