/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.util;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Usage;

public final class AnnotationUtil {
    private static final String BOOL_TRUE_VALUE = "true";

    private AnnotationUtil() {
    }

    private static EAnnotation getReverseAnnotation(Element element) {
        EAnnotation annot = UML2Util.getEAnnotation((EModelElement)element, (String)"http://www.eclipse.org/umlgen/annotation/c", (boolean)true);
        return annot;
    }

    private static void removeDetailEntry(EAnnotation annotation, String entryKey) {
        annotation.getDetails().removeKey((Object)entryKey);
    }

    static boolean isSameTypeBetweenCandHUnits(Element element) {
        EAnnotation reverseAnnotation = element.getEAnnotation("http://www.eclipse.org/umlgen/annotation/c");
        if (reverseAnnotation != null) {
            return reverseAnnotation.getDetails().containsKey((Object)"C_FILENAME") && !reverseAnnotation.getDetails().containsKey((Object)"H_FILENAME");
        }
        return false;
    }

    public static EAnnotation getDocumentationAnnotation(Element element) {
        return UML2Util.getEAnnotation((EModelElement)element, (String)"http://www.eclipse.org/umlgen/c/documentation", (boolean)true);
    }

    public static void removeEAnnotations(Element element, ITranslationUnit tu) {
        EAnnotation reverse = AnnotationUtil.getReverseAnnotation(element);
        if (tu.isHeaderUnit()) {
            AnnotationUtil.removeDetailEntry(reverse, "H_FILENAME");
        } else {
            AnnotationUtil.removeDetailEntry(reverse, "C_FILENAME");
        }
    }

    public static EAnnotation setFileLocationDetailEntry(Classifier classifier, ITranslationUnit tu) {
        EAnnotation annotation = AnnotationUtil.getReverseAnnotation((Element)classifier);
        String value = tu.getPath().removeFirstSegments(1).toString();
        annotation.getDetails().put((Object)(tu.isHeaderUnit() ? "H_FILENAME" : "C_FILENAME"), (Object)value);
        return annotation;
    }

    public static void setIfndefConditionDetailEntry(Classifier classifier, String condition) {
        EAnnotation reverseAnnotation = AnnotationUtil.getReverseAnnotation((Element)classifier);
        reverseAnnotation.getDetails().put((Object)"IFNDEF", (Object)condition);
    }

    public static void setRegisterDetailEntry(Property property, boolean isRegister) {
        EAnnotation reverseAnnotation = AnnotationUtil.getReverseAnnotation((Element)property);
        if (isRegister) {
            reverseAnnotation.getDetails().put((Object)"REGISTER", (Object)BOOL_TRUE_VALUE);
        } else {
            reverseAnnotation.getDetails().removeKey((Object)"REGISTER");
        }
        if (reverseAnnotation.getDetails().isEmpty()) {
            property.getEAnnotations().remove((Object)reverseAnnotation);
        }
    }

    public static void setVolatileDetailEntry(Property property, boolean isVolatile) {
        EAnnotation reverseAnnotation = AnnotationUtil.getReverseAnnotation((Element)property);
        if (isVolatile) {
            reverseAnnotation.getDetails().put((Object)"VOLATILE", (Object)BOOL_TRUE_VALUE);
        } else {
            reverseAnnotation.getDetails().removeKey((Object)"VOLATILE");
        }
        if (reverseAnnotation.getDetails().isEmpty()) {
            property.getEAnnotations().remove((Object)reverseAnnotation);
        }
    }

    public static void setLibraryDetailEntry(Usage usage, boolean status) {
        EAnnotation reverseAnnotation = AnnotationUtil.getReverseAnnotation((Element)usage);
        if (status) {
            reverseAnnotation.getDetails().put((Object)"STD_LIBRARY", (Object)BOOL_TRUE_VALUE);
        } else {
            reverseAnnotation.getDetails().removeKey((Object)"STD_LIBRARY");
        }
        if (reverseAnnotation.getDetails().isEmpty()) {
            usage.getEAnnotations().remove((Object)reverseAnnotation);
        }
    }

    public static String getRelativePath(NamedElement elt, String key) {
        EAnnotation reverseAnnotation = AnnotationUtil.getReverseAnnotation((Element)elt);
        String value = (String)reverseAnnotation.getDetails().get((Object)key);
        if (value != null && !"".equals(value)) {
            URI uri = EcoreUtil.getURI((EObject)elt);
            String relativePath = uri.toPlatformString(true);
            IResource rsc = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(relativePath));
            IProject project = rsc.getProject();
            return project.getFullPath().append(value).toString();
        }
        return "";
    }
}

