/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.util;

public final class CommentFormatter {
    private static final String SPACE = " ";
    private static final String REGEXP_STRIP_COMMENT_MARKS = "^/\\*+\\n|/? ?\\*+ ?/?";
    private static final String REPLACEMENT_STRING = "";
    private static final int MAX_CHAR_PER_LINE = 78;
    private static final String BEGIN_COMMENT_LINE = "/**\n";
    private static final String END_COMMENT_LINE = " */\n";
    private static final String INTERMEDIATE_COMMENT_LINE = " * ";

    private CommentFormatter() {
    }

    public static String wrapInLine(String string) {
        return String.format("/** %s */", string.trim());
    }

    public static String wrap(String string) {
        StringBuilder result = new StringBuilder(BEGIN_COMMENT_LINE);
        if (string.length() <= 78) {
            CommentFormatter.addLine(result, string.replaceAll("[\\n\\r]", SPACE).trim());
        } else {
            String[] commentArray;
            String[] stringArray = commentArray = string.split("\\r?\\n");
            int n = commentArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.length() > 78) {
                    String[] tokensArray = line.split(SPACE);
                    StringBuilder tmpLine = new StringBuilder();
                    String[] stringArray2 = tokensArray;
                    int n3 = tokensArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String token = stringArray2[n4];
                        if (tmpLine.length() + token.length() > 78) {
                            CommentFormatter.addLine(result, tmpLine.toString());
                            tmpLine = new StringBuilder();
                        }
                        tmpLine.append(token);
                        tmpLine.append(SPACE);
                        ++n4;
                    }
                    CommentFormatter.addLine(result, tmpLine.toString());
                } else {
                    CommentFormatter.addLine(result, line);
                }
                ++n2;
            }
        }
        result.append(END_COMMENT_LINE);
        return result.toString().trim();
    }

    private static void addLine(StringBuilder builder, String content) {
        builder.append(INTERMEDIATE_COMMENT_LINE);
        builder.append(content);
        builder.append("\n");
    }

    public static String unwrap(String comment) {
        return comment.replaceAll(REGEXP_STRIP_COMMENT_MARKS, REPLACEMENT_STRING);
    }
}

