/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.dsl.eth.presentation.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.umlgen.dsl.asl.Parameter;
import org.eclipse.umlgen.dsl.eth.Container;
import org.eclipse.umlgen.dsl.eth.EthernetConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsChoiceAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    private List<?> values;
    private Container container;
    private List<Property> propertiesInOtherContainers;

    public ComponentsChoiceAdapterFactoryContentProvider(AdapterFactory adapterFactory, List<?> values, Object object) {
        super(adapterFactory);
        this.values = values;
        if (object instanceof Container) {
            this.container = (Container)object;
        }
        this.propertiesInOtherContainers = this.getpropertiesInOtherContainers();
    }

    public ComponentsChoiceAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.values = Collections.EMPTY_LIST;
    }

    public Object[] getElements(Object object) {
        Object[] objects;
        ArrayList<EObject> result = new ArrayList<EObject>();
        Object[] objectArray = objects = super.getElements(object);
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray[n2];
            if (object2 instanceof Namespace && ((Namespace)object2).eContainer() instanceof Model && this.getChildren(object2).length > 0) {
                result.add((EObject)object2);
            }
            ++n2;
        }
        return result.toArray();
    }

    public Object[] getChildren(Object object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ItemProvider input = (ItemProvider)this.viewer.getInput();
        for (Object obj : input.getChildren()) {
            if (!(obj instanceof EObject) || ((EObject)obj).eContainer() != object || !this.hasChildren(obj) && (!this.isCandidate(obj) || !this.hasToDisplayEmptyItems(obj))) continue;
            result.add((EObject)obj);
        }
        return result.toArray();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    protected boolean hasToDisplayEmptyItems(Object obj) {
        return !this.values.contains(obj);
    }

    private boolean isCandidate(Object obj) {
        if (obj instanceof Property) {
            EObject conf;
            Property aProperty = (Property)obj;
            if (this.container != null && (conf = this.container.eContainer()) instanceof EthernetConf) {
                for (Connector connector : ((EthernetConf)conf).getConnectors()) {
                    boolean check = false;
                    for (ConnectorEnd connectorEnd : connector.getEnds()) {
                        Property property = connectorEnd.getPartWithPort();
                        if (property != aProperty) continue;
                        if (!this.isInTheSameContainer(this.getOtherProperties(connector, connectorEnd)) && !this.isInOtherContainer((EthernetConf)conf, aProperty)) {
                            check = true;
                            continue;
                        }
                        return false;
                    }
                    if (!check) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private List<Property> getOtherProperties(Connector connector, ConnectorEnd connectorEnd) {
        Property ref = connectorEnd.getPartWithPort();
        ArrayList<Property> result = new ArrayList<Property>();
        for (ConnectorEnd currentConnectorEnd : connector.getEnds()) {
            if (currentConnectorEnd.getPartWithPort() == ref) continue;
            result.add(currentConnectorEnd.getPartWithPort());
        }
        return result;
    }

    private boolean isInTheSameContainer(List<Property> properties) {
        for (Property property : properties) {
            if (!this.values.contains(property)) continue;
            return true;
        }
        return false;
    }

    private boolean isInOtherContainer(EthernetConf conf, Property property) {
        return this.propertiesInOtherContainers.contains(property);
    }

    private List<Property> getpropertiesInOtherContainers() {
        ArrayList<Property> existingProperties = new ArrayList<Property>();
        for (Parameter parameter : ((EthernetConf)this.container.eContainer()).getParameters()) {
            if (!(parameter instanceof Container) || parameter == this.container) continue;
            existingProperties.addAll((Collection<Property>)((Container)parameter).getComponents());
        }
        return existingProperties;
    }
}

