/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.c.services;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Clause;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.umlgen.c.common.ui.PreferenceStoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UML2Services {
    private UML2Services() {
    }

    public static Collection<Dependency> getClientDependencies(NamedElement elt) {
        return elt.getClientDependencies();
    }

    public static String getSourcePackageName(NamedElement elt) {
        URI uri = EcoreUtil.getURI((EObject)elt);
        String relativePath = uri.toPlatformString(true);
        IResource rsc = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(relativePath));
        if (rsc != null) {
            IPreferenceStore store = PreferenceStoreManager.getPreferenceStore((IProject)rsc.getProject());
            return store.getString("srcPackageName");
        }
        return "";
    }

    public static String eResourceName(EObject eObject) {
        return eObject.eResource().getURI().trimFileExtension().lastSegment();
    }

    public static MergeNode getCorrespondingMergeNode(DecisionNode decisionNode) {
        return UML2Services.getNextMergeNode((ActivityNode)decisionNode);
    }

    private static MergeNode getNextMergeNode(ActivityNode node) {
        MergeNode result = null;
        if (node.getOutgoings().size() > 0) {
            for (ActivityEdge flow : node.getOutgoings()) {
                if (!(flow.getTarget() instanceof MergeNode)) continue;
                return (MergeNode)flow.getTarget();
            }
            for (ActivityEdge flow : node.getOutgoings()) {
                MergeNode mergeNode = UML2Services.getNextMergeNode(flow.getTarget());
                if (mergeNode == null) continue;
                result = mergeNode;
                break;
            }
        }
        return result;
    }

    public static boolean usesFallthrough(Clause clause) {
        ExecutableNode body = (ExecutableNode)clause.getBodies().get(0);
        for (Clause succClause : clause.getSuccessorClauses()) {
            if (!((ExecutableNode)succClause.getBodies().get(0)).equals(body)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferencedByClause(ActivityNode node) {
        Collection<EStructuralFeature.Setting> references = new EcoreUtil.UsageCrossReferencer(node.eResource()){
            private static final long serialVersionUID = 1L;

            protected boolean crossReference(EObject eObject, EReference eReference, EObject referencedObj) {
                return super.crossReference(eObject, eReference, referencedObj) && eReference == UMLPackage.Literals.CLAUSE__BODY;
            }

            protected boolean containment(EObject eObject) {
                return !(eObject instanceof OpaqueAction);
            }

            public Collection<EStructuralFeature.Setting> findUsage(EObject eObject) {
                return super.findUsage(eObject);
            }
        }.findUsage((EObject)node);
        return references.size() > 0;
    }
}

