/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.ui.launch.tabs;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.umlgen.gen.java.ui.UML2JavaUIActivator;
import org.eclipse.umlgen.gen.java.ui.launch.tabs.AbstractUML2JavaLaunchConfigurationTab;
import org.eclipse.umlgen.gen.java.ui.utils.UML2JavaMessages;

public class UML2JavaGeneralLaunchConfigurationTab
extends AbstractUML2JavaLaunchConfigurationTab {
    private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
    private Text modelPathText;
    private Text defaultProjectNameText;
    private Text sourceFolderPathText;
    private Text outputFolderPathText;
    private Combo executionEnvJRECombo;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        this.createGenerationGroup(composite, font);
        this.createJavaGroup(composite, font);
        this.setControl((Control)composite);
        this.update();
    }

    private void createGenerationGroup(Composite composite, Font font) {
        Group generationGroup = this.createGroup(composite, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.GenerationGroupName"), 3, 1, 768);
        Composite comp = new Composite((Composite)generationGroup, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label modelPathLabel = new Label(comp, 0);
        modelPathLabel.setText(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.UMLModelPathLabel"));
        this.modelPathText = new Text(comp, 2052);
        this.modelPathText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.modelPathText.setLayoutData((Object)gd);
        this.modelPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        Button browseModelButton = this.createPushButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.BrowseButtonName"), null);
        browseModelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(UML2JavaGeneralLaunchConfigurationTab.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.UMLModelDialogTitle"));
                dialog.setInitialPattern("*.uml");
                dialog.open();
                if (dialog.getResult() != null && dialog.getResult().length > 0) {
                    Object[] results;
                    Object[] objectArray = results = dialog.getResult();
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IFile) {
                            UML2JavaGeneralLaunchConfigurationTab.this.modelPathText.setText(((IFile)result).getFullPath().toString());
                            break;
                        }
                        ++n2;
                    }
                }
                UML2JavaGeneralLaunchConfigurationTab.this.update();
                UML2JavaGeneralLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createHelpButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.UMLModelPathHelp"));
    }

    private void createJavaGroup(Composite composite, Font font) {
        Group javaGroup = this.createGroup(composite, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.JavaGroupName"), 3, 1, 768);
        Composite comp = new Composite((Composite)javaGroup, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label defaultProjectNameLabel = new Label(comp, 0);
        defaultProjectNameLabel.setText(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.DefaultProjectNameLabel"));
        this.defaultProjectNameText = new Text(comp, 2052);
        this.defaultProjectNameText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.defaultProjectNameText.setLayoutData((Object)gd);
        this.defaultProjectNameText.setText("org.eclipse.uml.to.java");
        this.defaultProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        this.createHelpButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.DefaultProjectNameHelp"));
        Label sourceFolderPathLabel = new Label(comp, 0);
        sourceFolderPathLabel.setText(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.SourceFolderPathLabel"));
        this.sourceFolderPathText = new Text(comp, 2052);
        this.sourceFolderPathText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.sourceFolderPathText.setLayoutData((Object)gd);
        this.sourceFolderPathText.setText("src/main/java");
        this.sourceFolderPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        this.createHelpButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.SourceFolderPathHelp"));
        Label outputFolderPathLabel = new Label(comp, 0);
        outputFolderPathLabel.setText(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.OutputFolderPathLabel"));
        this.outputFolderPathText = new Text(comp, 2052);
        this.outputFolderPathText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.outputFolderPathText.setLayoutData((Object)gd);
        this.outputFolderPathText.setText("target/classes");
        this.outputFolderPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        this.createHelpButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.OutputFolderPathHelp"));
        Label jreExecutionEnvironmentLabel = new Label(comp, 0);
        jreExecutionEnvironmentLabel.setText(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.JREExecutionEnvironmentLabel"));
        this.executionEnvJRECombo = new Combo(comp, 8);
        this.executionEnvJRECombo.setLayoutData((Object)new GridData(4, 2, true, false));
        String selectedItem = this.getLastSelectedEE();
        int selectionIndex = this.executionEnvJRECombo.getSelectionIndex();
        IExecutionEnvironment[] fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        Arrays.sort(fInstalledEEs, new Comparator<IExecutionEnvironment>(){

            @Override
            public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                return Policy.getComparator().compare(arg0.getId(), arg1.getId());
            }
        });
        selectionIndex = -1;
        String[] eeLabels = new String[fInstalledEEs.length];
        String[] fEECompliance = new String[fInstalledEEs.length];
        int i = 0;
        while (i < fInstalledEEs.length) {
            eeLabels[i] = fInstalledEEs[i].getId();
            if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                selectionIndex = i;
            }
            fEECompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)fInstalledEEs[i]);
            ++i;
        }
        this.executionEnvJRECombo.setItems(eeLabels);
        if (selectionIndex == -1) {
            this.executionEnvJRECombo.setText(this.getDefaultEEName());
        } else {
            this.executionEnvJRECombo.setText(selectedItem);
        }
        this.executionEnvJRECombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        this.executionEnvJRECombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UML2JavaGeneralLaunchConfigurationTab.this.update();
            }
        });
        this.createHelpButton(comp, UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.JREExecutionEnvironmentHelp"));
    }

    private String getLastSelectedEE() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
    }

    private String getDefaultEEName() {
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (defaultVM != null) {
            IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
            int n = environments.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
                IVMInstall eeDefaultVM = environment.getDefaultVM();
                if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                    return environment.getId();
                }
                ++n2;
            }
        }
        String defaultCC = defaultVM instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)defaultVM), (String)"1.4") : "1.4";
        String result = "JavaSE-1.7";
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
        int n = environments.length;
        int n3 = 0;
        while (n3 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n3];
            String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environment);
            if (defaultCC.endsWith(eeCompliance)) {
                result = environment.getId();
                break;
            }
            ++n3;
        }
        return result;
    }

    private void update() {
        IFile model;
        String text;
        this.setErrorMessage(null);
        this.getLaunchConfigurationDialog().updateButtons();
        this.getLaunchConfigurationDialog().updateMessage();
        if (this.modelPathText != null && (text = this.modelPathText.getText()) != null && text.length() > 0 && (model = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(text))) != null && !model.exists()) {
            this.setErrorMessage(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.MissingInputModel"));
        }
        if (this.sourceFolderPathText != null && this.sourceFolderPathText.getText() != null && this.sourceFolderPathText.getText().trim().length() == 0) {
            this.setErrorMessage(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.MissingSourceFolderPath"));
        } else if (this.outputFolderPathText != null && this.outputFolderPathText.getText() != null && this.outputFolderPathText.getText().trim().length() == 0) {
            this.setErrorMessage(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.MissingOutputFolderPath"));
        } else if (this.defaultProjectNameText != null && this.defaultProjectNameText.getText() != null && this.defaultProjectNameText.getText().trim().length() == 0) {
            this.setErrorMessage(UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.MissingDefaultProjectName"));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("uml_model_path", "");
        if (this.modelPathText != null) {
            this.modelPathText.setText("");
        }
        configuration.setAttribute("default_project_name", "org.eclipse.uml.to.java");
        if (this.defaultProjectNameText != null) {
            this.defaultProjectNameText.setText("org.eclipse.uml.to.java");
        }
        configuration.setAttribute("source_folder_path", "src/main/java");
        if (this.sourceFolderPathText != null) {
            this.sourceFolderPathText.setText("src/main/java");
        }
        configuration.setAttribute("output_folder_path", "target/classes");
        if (this.outputFolderPathText != null) {
            this.outputFolderPathText.setText("target/classes");
        }
        configuration.setAttribute("jre_execution_environment", "JavaSE-1.7");
        if (this.executionEnvJRECombo != null) {
            this.executionEnvJRECombo.setText("JavaSE-1.7");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String attribute = configuration.getAttribute("uml_model_path", "");
            this.modelPathText.setText(attribute);
            attribute = configuration.getAttribute("source_folder_path", "src/main/java");
            this.sourceFolderPathText.setText(attribute);
            attribute = configuration.getAttribute("output_folder_path", "target/classes");
            this.outputFolderPathText.setText(attribute);
            attribute = configuration.getAttribute("default_project_name", "org.eclipse.uml.to.java");
            this.defaultProjectNameText.setText(attribute);
            attribute = configuration.getAttribute("jre_execution_environment", "JavaSE-1.7");
            this.executionEnvJRECombo.setText(attribute);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String umlModelPath = this.modelPathText.getText();
        configuration.setAttribute("uml_model_path", umlModelPath);
        String sourceFolderPath = this.sourceFolderPathText.getText();
        configuration.setAttribute("source_folder_path", sourceFolderPath);
        String outputFolderPath = this.outputFolderPathText.getText();
        configuration.setAttribute("output_folder_path", outputFolderPath);
        String defaultProjectName = this.defaultProjectNameText.getText();
        configuration.setAttribute("default_project_name", defaultProjectName);
        String jreExecutionEnvironment = this.executionEnvJRECombo.getText();
        configuration.setAttribute("jre_execution_environment", jreExecutionEnvironment);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean isValid = true;
        try {
            String attribute = configuration.getAttribute("uml_model_path", "");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
            attribute = configuration.getAttribute("source_folder_path", "src/main/java");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
            attribute = configuration.getAttribute("output_folder_path", "target/classes");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
            attribute = configuration.getAttribute("default_project_name", "org.eclipse.uml.to.java");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
            attribute = configuration.getAttribute("jre_execution_environment", "JavaSE-1.7");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
        }
        return isValid;
    }

    public String getName() {
        return UML2JavaMessages.getString("UML2JavaGeneralLaunchConfigurationTab.Name");
    }

    public Image getImage() {
        return UML2JavaUIActivator.getDefault().getImage("icons/model_obj.gif");
    }
}

