/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.umlgen.gen.java.services.UML2JavaConfigurationHolder;

public class WorkspaceServices {
    private static final String LINE_SEPARATOR = "line.separator";

    public boolean resourceExists(String path) {
        return new File(path).exists();
    }

    public void createFolder(String path) {
        File file = new File(path);
        file.mkdirs();
    }

    public void importProject(String projectName) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        System.getProperty(LINE_SEPARATOR);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IProjectDescription descr = workspace.loadProjectDescription(workspaceRoot.getLocation().append(projectName).append(".project"));
            IProject project = workspaceRoot.getProject(projectName);
            if (project.exists()) {
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                project.create(descr, (IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException ce) {
            AcceleoEnginePlugin.log((Exception)((Object)ce), (boolean)true);
        }
    }

    public void createDefaultProject(EObject eObject) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            String projectName = UML2JavaConfigurationHolder.getDefaultProjectName(eObject);
            IProject project = workspaceRoot.getProject(projectName);
            if (project.exists() && project.isAccessible()) {
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)monitor);
                }
            } else {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
                IProject intputContainer = project;
                String sourceFolderName = UML2JavaConfigurationHolder.getSourceFolderPath(eObject);
                StringTokenizer stringTokenizer = new StringTokenizer(sourceFolderName, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    IFolder src = intputContainer.getFolder((IPath)new Path(token));
                    if (!src.exists()) {
                        src.create(true, true, (IProgressMonitor)monitor);
                    }
                    intputContainer = src;
                }
                IProject outputContainer = project;
                String outputFolderName = UML2JavaConfigurationHolder.getOutputFolderPath(eObject);
                stringTokenizer = new StringTokenizer(outputFolderName, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    IFolder out = outputContainer.getFolder((IPath)new Path(token));
                    if (!out.exists()) {
                        out.create(true, true, (IProgressMonitor)monitor);
                    }
                    outputContainer = out;
                }
                IProjectDescription description = project.getDescription();
                String[] natures = new String[]{};
                natures = "OSGi Bundles and Subsystems".equals(UML2JavaConfigurationHolder.getComponentBasedArchitecture(eObject)) || "Eclipse Plugins, Features and Update Sites".equals(UML2JavaConfigurationHolder.getComponentBasedArchitecture(eObject)) ? new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"} : new String[]{"org.eclipse.jdt.core.javanature"};
                description.setNatureIds(natures);
                project.setDescription(description, (IProgressMonitor)monitor);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
                IExecutionEnvironmentsManager executionEnvironmentsManager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment[] executionEnvironments = executionEnvironmentsManager.getExecutionEnvironments();
                String defaultJREExecutionEnvironment = UML2JavaConfigurationHolder.getJREExecutionEnvironment(eObject);
                IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments;
                int n = executionEnvironments.length;
                int n2 = 0;
                while (n2 < n) {
                    IExecutionEnvironment iExecutionEnvironment = iExecutionEnvironmentArray[n2];
                    if (defaultJREExecutionEnvironment.equals(iExecutionEnvironment.getId())) {
                        entries.add(JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IExecutionEnvironment)iExecutionEnvironment)));
                        break;
                    }
                    ++n2;
                }
                javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
                IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
                javaProject.setOutputLocation(outputContainer.getFullPath(), (IProgressMonitor)monitor);
                IPackageFragmentRoot packageRoot = javaProject.getPackageFragmentRoot(intputContainer.getFullPath().toString());
                newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)packageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)outputContainer.getFullPath());
                javaProject.setRawClasspath(newEntries, null);
                IFile buildPropertiesFile = project.getFile("build.properties");
                if (!buildPropertiesFile.exists()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("#################################################################################" + System.getProperty(LINE_SEPARATOR));
                    stringBuilder.append("## " + UML2JavaConfigurationHolder.getCopyrightAndLicense(eObject) + System.getProperty(LINE_SEPARATOR));
                    stringBuilder.append("#################################################################################" + System.getProperty(LINE_SEPARATOR));
                    stringBuilder.append("source.. = " + UML2JavaConfigurationHolder.getSourceFolderPath(eObject) + System.getProperty(LINE_SEPARATOR));
                    stringBuilder.append("output.. = " + UML2JavaConfigurationHolder.getOutputFolderPath(eObject) + System.getProperty(LINE_SEPARATOR));
                    stringBuilder.append(System.getProperty(LINE_SEPARATOR));
                    buildPropertiesFile.create((InputStream)new ByteArrayInputStream(stringBuilder.toString().getBytes()), true, (IProgressMonitor)monitor);
                }
            }
        }
        catch (CoreException coreException) {
            AcceleoEnginePlugin.log((Exception)((Object)coreException), (boolean)true);
        }
    }

    public void formatProjectCode(String projectName) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return;
        }
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            options.put("org.eclipse.jdt.core.compiler.source", "1.5");
            options.put("org.eclipse.jdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)1));
            final CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.isAccessible() && resource instanceof IFile && "java".equals(((IFile)resource).getFileExtension())) {
                        IFile iFile = (IFile)resource;
                        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile);
                        String contents = compilationUnit.getBuffer().getContents();
                        TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, System.getProperty(WorkspaceServices.LINE_SEPARATOR));
                        Document document = new Document(contents);
                        try {
                            if (edit != null) {
                                edit.apply((IDocument)document);
                            }
                        }
                        catch (MalformedTreeException e) {
                            e.printStackTrace();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        iFile.setContents((InputStream)new ByteArrayInputStream(document.get().getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
                        return true;
                    }
                    return true;
                }
            });
            project.build(6, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

