/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.comments;

import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class NodeLocationInfo {
    private int startingOffset;
    private int endingOffset;
    private int startingLine;
    private int endingLine;
    private int startingOffsetForInline;
    private int endingOffsetForInline;

    public NodeLocationInfo(IASTNode node) {
        this.startingOffset = node.getFileLocation().getNodeOffset();
        this.endingOffset = this.startingOffset + node.getFileLocation().getNodeLength() - 1;
        this.startingLine = node.getFileLocation().getStartingLineNumber();
        this.endingLine = node.getFileLocation().getEndingLineNumber();
        this.startingOffsetForInline = this.startingOffset;
        if (node instanceof IASTSwitchStatement) {
            IASTStatement nextEnclosedNode = ((IASTSwitchStatement)node).getBody();
            this.endingOffsetForInline = nextEnclosedNode.getFileLocation().getNodeOffset() - 1;
        } else if (node instanceof IASTDoStatement) {
            IASTStatement nextEnclosedNode = ((IASTDoStatement)node).getBody();
            this.endingOffsetForInline = nextEnclosedNode.getFileLocation().getNodeOffset() - 1;
        } else if (node instanceof IASTWhileStatement) {
            IASTStatement nextEnclosedNode = ((IASTWhileStatement)node).getBody();
            this.endingOffsetForInline = nextEnclosedNode.getFileLocation().getNodeOffset() - 1;
        } else if (node instanceof IASTForStatement) {
            IASTStatement nextEnclosedNode = ((IASTForStatement)node).getBody();
            this.endingOffsetForInline = nextEnclosedNode.getFileLocation().getNodeOffset() - 1;
        } else if (node instanceof IASTIfStatement) {
            IASTStatement nextEnclosedNode = ((IASTIfStatement)node).getThenClause();
            this.endingOffsetForInline = nextEnclosedNode.getFileLocation().getNodeOffset() - 1;
        } else {
            this.endingOffsetForInline = node instanceof IASTCompoundStatement ? this.startingOffsetForInline : this.endingOffset;
        }
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public void setStartingOffset(int startingOffset) {
        this.startingOffset = startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public void setEndingOffset(int endingOffset) {
        this.endingOffset = endingOffset;
    }

    public int getStartingLine() {
        return this.startingLine;
    }

    public void setStartingLine(int startingLine) {
        this.startingLine = startingLine;
    }

    public int getEndingLine() {
        return this.endingLine;
    }

    public void setEndingLine(int endingLine) {
        this.endingLine = endingLine;
    }

    public int getStartingOffsetForInline() {
        return this.startingOffsetForInline;
    }

    public void setStartingOffsetForInline(int startingOffsetForInline) {
        this.startingOffsetForInline = startingOffsetForInline;
    }

    public int getEndingOffsetForInline() {
        return this.endingOffsetForInline;
    }

    public void setEndingOffsetForInline(int endingOffsetForInline) {
        this.endingOffsetForInline = endingOffsetForInline;
    }
}

