/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.diagram.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.umlgen.reverse.java.diagram.diagram.AbstractDiagramUtils;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagramUtils
extends AbstractDiagramUtils {
    public static ActivityDiagramUtils INSTANCE = new ActivityDiagramUtils();

    @Override
    protected Set<Diagram> specificDiagramCreation(Package contents, ModelSet resourceSet) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        this.findActivities(contents, activities);
        for (Activity activity : activities) {
            Diagram diagram = ViewService.createDiagram((EObject)contents, (String)"PapyrusUMLActivityDiagram", (PreferencesHint)new PreferencesHint("org.eclipse.papyrus.uml.diagram.activity"));
            LogUtils.logMessage((String)("   activity diagram for " + contents.getName()));
            Element owner = activity.getOwner();
            String ownerString = owner instanceof NamedElement ? "." + ((NamedElement)owner).getName() : "";
            String ownerPackageName = owner.getNearestPackage().getQualifiedName().replaceAll("::", ".");
            diagram.setName(String.valueOf(ownerPackageName) + ownerString + "." + activity.getName());
            diagram.setElement((EObject)activity);
            this.addDiagramToResource(resourceSet, diagram);
            this.initDiagram(diagram, activity, resourceSet);
            diagrams.add(diagram);
        }
        return diagrams;
    }

    protected void initDiagram(Diagram diagram, Activity activity, ModelSet modelSet) {
        HashMap<ActivityNode, Node> viewMap = new HashMap<ActivityNode, Node>();
        Node mainNode = this.addNode(modelSet, (View)diagram, (EObject)activity, "2001", new PreferencesHint("org.eclipse.papyrus.uml.diagram.activity"));
        for (Object childObj : mainNode.getChildren()) {
            View childView = (View)childObj;
            if (!"7004".equals(childView.getType())) continue;
            for (ActivityNode node : activity.getNodes()) {
                Node createdNode = this.addNode(modelSet, childView, (EObject)node, String.valueOf(UMLVisualIDRegistry.getNodeVisualID((View)childView, (EObject)node)), new PreferencesHint("org.eclipse.papyrus.uml.diagram.activity"));
                viewMap.put(node, createdNode);
            }
            for (ActivityEdge edge : activity.getEdges()) {
                View node1 = (View)viewMap.get(edge.getSource());
                View node2 = (View)viewMap.get(edge.getTarget());
                int typeID = UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)edge);
                IElementType elementType = UMLElementTypes.getElementType((int)typeID);
                CreateElementRequestAdapter adapter = new CreateElementRequestAdapter((CreateElementRequest)new CreateRelationshipRequest(elementType));
                String type = String.valueOf(typeID);
                PreferencesHint preferencesHint = new PreferencesHint("org.eclipse.papyrus.uml.diagram.activity");
                Edge edgeView = this.addEdge(modelSet, (IAdaptable)adapter, diagram, type, -1, true, preferencesHint);
                this.setEdgeInfo(modelSet, edgeView, node1, node2, (EObject)edge);
            }
        }
    }

    protected void findActivities(Package contents, List<Activity> activities) {
        for (EObject obj : contents.getPackagedElements()) {
            if (obj instanceof Package) {
                this.findActivities((Package)obj, activities);
                continue;
            }
            if (!(obj instanceof Class)) continue;
            this.findActivities((Class)obj, activities);
        }
    }

    protected void findActivities(Class clazz, List<Activity> activities) {
        EList ownedBehaviors = clazz.getOwnedBehaviors();
        for (Behavior behavior : ownedBehaviors) {
            if (!(behavior instanceof Activity)) continue;
            activities.add((Activity)behavior);
        }
    }
}

