/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.reverse.java.AbstractJava2UMLConverter;
import org.eclipse.umlgen.reverse.java.Java2UMLConverter;
import org.eclipse.umlgen.reverse.java.internal.ReversePlugin;
import org.eclipse.umlgen.reverse.java.internal.wizards.Java2UMLWizardPage;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

public class Java2UMLWizard
extends Wizard
implements INewWizard {
    protected Java2UMLWizardPage page;
    protected ISelection selection;
    protected IJavaElement javaElement;

    public Java2UMLWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new Java2UMLWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final VisibilityKind visibility = this.page.getVisibilityKind();
        final AbstractJava2UMLConverter.ActivityGeneration activityGen = this.page.getActivityGeneration();
        final String[] importList = this.page.getImportList();
        final String modelName = this.page.getModelName();
        int logLevel = this.page.getLoggingLevel();
        LogUtils.setLogLevel(logLevel);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        Java2UMLWizard.this.doFinish(containerName, fileName, importList, monitor, modelName, visibility, activityGen);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(String containerName, String fileName, String[] importList, IProgressMonitor monitor, String modelName, VisibilityKind visibility, AbstractJava2UMLConverter.ActivityGeneration activityGen) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        if (this.javaElement == null) {
            this.throwCoreException("No java element selected.");
        }
        Java2UMLConverter converter = null;
        converter = new Java2UMLConverter();
        converter.setImportList(importList);
        converter.setModelName(modelName);
        converter.setVisibility(visibility);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource emfResource = resourceSet.createResource(fileURI);
        LogUtils.logMessage("Convert " + this.javaElement.getElementName());
        converter.convert(this.javaElement, emfResource, activityGen);
        HashMap options = new HashMap();
        try {
            LogUtils.logMessage("Saving uml file " + fileURI.path());
            emfResource.save(options);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Status status = new Status(4, ReversePlugin.getId(), 0, "An error occured during saving resource", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        this.javaElement.getResource().refreshLocal(1, null);
        LogUtils.logMessage("Uml file " + fileURI.path() + " saved");
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, ReversePlugin.getId(), 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public void setJavaElement(IJavaElement elt) {
        this.javaElement = elt;
    }

    public void setActivityGen(AbstractJava2UMLConverter.ActivityGeneration activityGen) {
        this.page.setActivityGen(activityGen);
    }
}

