/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

public class Java2UMLLogListener
implements ILogListener {
    private File logFile;

    public Java2UMLLogListener(File dir, String name) throws CoreException {
        if (dir != null && dir.isDirectory()) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
            this.logFile = new File(dir, String.valueOf(name) + "_" + timeStamp + ".txt");
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtils.logThrowable(e);
            }
        }
    }

    public void logging(IStatus status, String plugin) {
        if (this.logFile == null) {
            return;
        }
        if (!this.logFile.exists()) {
            return;
        }
        try {
            FileWriter fstream = new FileWriter(this.logFile, true);
            BufferedWriter fbw = new BufferedWriter(fstream);
            String severityString = null;
            int severity = status.getSeverity();
            if (severity == 0) {
                severityString = "OK";
            } else if (severity == 4) {
                severityString = "ERROR";
            } else if (severity == 2) {
                severityString = "WARNING";
            } else if (severity == 1) {
                severityString = "INFO";
            } else if (severity == 8) {
                severityString = "CANCEL";
            }
            String logMessage = String.valueOf(severityString) + " - " + status.getMessage();
            fbw.write(logMessage);
            fbw.newLine();
            fbw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
    }
}

