/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.dsl.eth.presentation.custom;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.umlgen.dsl.eth.Container;
import org.eclipse.umlgen.dsl.eth.EthPackage;
import org.eclipse.umlgen.dsl.eth.EthernetConf;
import org.eclipse.umlgen.dsl.eth.presentation.EthEditor;
import org.eclipse.umlgen.dsl.eth.presentation.util.Requestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEthEditor
extends EthEditor {
    protected EContentAdapter consistencyAdapter = new EContentAdapter(){
        private PropertyToContainerReferencer mapPropertyToContainer;

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == EthPackage.Literals.ETHERNET_CONF__CONNECTORS && notification.getEventType() == 4) {
                Connector connector = (Connector)notification.getOldValue();
                if (this.mapPropertyToContainer == null) {
                    this.mapPropertyToContainer = new PropertyToContainerReferencer(connector.eResource().getResourceSet());
                    this.mapPropertyToContainer.computeCrossReferences();
                }
                for (ConnectorEnd connectorEnd : connector.getEnds()) {
                    Property property = connectorEnd.getPartWithPort();
                    Type component = property.getType();
                    if (!(component instanceof Class) || CustomEthEditor.hasOtherEthernetConnector((EthernetConf)notification.getNotifier(), connector, (Class)component)) continue;
                    Collection settings = (Collection)this.mapPropertyToContainer.get(property);
                    for (EStructuralFeature.Setting setting : settings) {
                        if (setting.getEStructuralFeature() != EthPackage.Literals.CONTAINER__COMPONENTS) continue;
                        Container container = (Container)setting.getEObject();
                        container.getComponents().remove((Object)property);
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }
    };

    @Override
    public void createModel() {
        super.createModel();
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.consistencyAdapter);
    }

    private static boolean hasOtherEthernetConnector(EthernetConf ethernetConf, Connector currentConnector, Class component) {
        Set<Connector> connectors = CustomEthEditor.getAllConnectors(component);
        connectors.remove(currentConnector);
        for (Connector connect : ethernetConf.getConnectors()) {
            if (!connectors.contains(connect)) continue;
            return true;
        }
        return false;
    }

    private static Set<Connector> getAllConnectors(Class clazz) {
        HashSet<Connector> connectors = new HashSet<Connector>();
        for (Port port : clazz.getOwnedPorts()) {
            connectors.addAll(Requestor.getConnectors(port));
        }
        return connectors;
    }

    private static class PropertyToContainerReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;

        protected PropertyToContainerReferencer(ResourceSet arg0) {
            super(arg0);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return eReference == EthPackage.Literals.CONTAINER__COMPONENTS;
        }

        public void computeCrossReferences() {
            this.crossReference();
            this.done();
        }
    }
}

