/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.ui.launch;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.umlgen.gen.java.ui.UML2JavaUIActivator;

public class LaunchShortcut
implements ILaunchShortcut {
    private IFile file;

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            for (Object object : list) {
                if (!(object instanceof IFile) || ((IFile)object).getFileExtension() == null || !"uml".equals(((IFile)object).getFileExtension())) continue;
                this.file = (IFile)object;
                break;
            }
        }
        if (this.file != null) {
            this.generate(mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile iFile;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IAdaptable && (iFile = (IFile)input.getAdapter(IFile.class)) != null && iFile.getFileExtension() != null && "uml".equals(iFile.getFileExtension())) {
            this.file = iFile;
        }
        if (this.file != null) {
            this.generate(mode);
        }
    }

    private void generate(String mode) {
        ILaunchConfiguration launchConfiguration = this.findLaunchConfiguration();
        if (launchConfiguration == null) {
            launchConfiguration = this.createConfiguration();
        }
        if (launchConfiguration != null && launchConfiguration.exists()) {
            DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)mode);
        }
    }

    protected ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            String computedModelPath = this.file.getFullPath().toString();
            ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.umlgen.gen.java.ui.launchConfigurationType");
            wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("UML2Java"));
            wc.setAttribute("uml_model_path", computedModelPath);
            wc.setMappedResources(new IResource[]{this.file});
            config = wc.doSave();
            StructuredSelection selection = config == null ? new StructuredSelection() : new StructuredSelection((Object)config);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)selection, (String)"org.eclipse.debug.ui.launchGroup.run");
        }
        catch (CoreException e) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                MessageDialog.openError((Shell)window.getShell(), (String)"", (String)e.getStatus().getMessage());
            }
            UML2JavaUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return config;
    }

    protected ILaunchConfiguration findLaunchConfiguration() {
        String computedModelPath = this.file.getFullPath().toString();
        ILaunchConfigurationType configurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.umlgen.gen.java.ui.launchConfigurationType");
        try {
            ILaunchConfiguration[] launchConfigurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configurationType);
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n2];
                String modelPath = iLaunchConfiguration.getAttribute("uml_model_path", "");
                if (modelPath != null && modelPath.equals(computedModelPath)) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
        }
        return null;
    }
}

