/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.vex.core.internal.core.DisplayDevice;
import org.eclipse.vex.core.internal.widget.swt.SwtDisplayDevice;
import org.eclipse.vex.ui.internal.VexPreferences;
import org.eclipse.vex.ui.internal.config.ConfigLoaderJob;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistryImpl;
import org.osgi.framework.BundleContext;

public class VexPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.vex.ui";
    private static VexPlugin instance;
    private final ConfigurationRegistry configurationRegistry = new ConfigurationRegistryImpl(new ConfigLoaderJob());
    private VexPreferences preferences = null;

    public static VexPlugin getDefault() {
        return instance;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, ID, 0, message, null));
    }

    public void log(int severity, String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(severity, ID, 0, message, exception));
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }

    public VexPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new VexPreferences(this.getPreferenceStore(), this.getConfigurationRegistry());
        }
        return this.preferences;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        if (instance != null) {
            throw new IllegalStateException("This plug-in must be a singleton.");
        }
        instance = this;
        DisplayDevice.setCurrent((DisplayDevice)new SwtDisplayDevice());
        this.configurationRegistry.loadConfigurations();
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }
}

