/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal;

import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vex.core.internal.css.IStyleSheetProvider;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.provisional.dom.DocumentContentModel;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.VexDocumentContentModel;
import org.osgi.service.prefs.BackingStoreException;

public class VexPreferences
implements IStyleSheetProvider {
    public static final String INDENTATION_CHAR_CHOICE = "indetationCharChoice";
    public static final String INDENTATION_CHAR_TAB = "\t";
    public static final String INDENTATION_CHAR_SPACE = " ";
    public static final String INDENTATION_SIZE = "indetationSize";
    public static final String LINE_WIDTH = "lineWidth";
    private static final String PREFERRED_STYLE_SUFFIX = ".style";
    private final IPreferenceStore preferenceStore;
    private final ConfigurationRegistry configurationRegistry;

    public VexPreferences(IPreferenceStore preferenceStore, ConfigurationRegistry configurationRegistry) {
        this.preferenceStore = preferenceStore;
        this.configurationRegistry = configurationRegistry;
    }

    public void setPreferredStyleId(DocumentType doctype, String styleId) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        String key = VexPreferences.getStylePreferenceKey(doctype.getUniqueId());
        preferences.put(key, styleId);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            VexPlugin.getDefault().log(4, Messages.getString("VexEditor.errorSavingStylePreference"), e);
        }
    }

    public String getPreferredStyleId(DocumentType doctype) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        String preferredStyleId = preferences.get(VexPreferences.getStylePreferenceKey(doctype.getUniqueId()), null);
        return preferredStyleId;
    }

    private static String getStylePreferenceKey(String publicId) {
        return String.valueOf(publicId) + PREFERRED_STYLE_SUFFIX;
    }

    public Style getPreferredStyle(DocumentType doctype) {
        return this.configurationRegistry.getStyle(doctype, this.getPreferredStyleId(doctype));
    }

    public String getIndentationPattern() {
        String indentationChar = this.preferenceStore.getString(INDENTATION_CHAR_CHOICE);
        int indentationSize = this.preferenceStore.getInt(INDENTATION_SIZE);
        char[] pattern = new char[indentationSize];
        Arrays.fill(pattern, indentationChar.charAt(0));
        return new String(pattern);
    }

    public int getLineWidth() {
        return this.preferenceStore.getInt(LINE_WIDTH);
    }

    public StyleSheet getStyleSheet(DocumentContentModel documentContentModel) {
        Style style = null;
        if (documentContentModel instanceof VexDocumentContentModel) {
            style = this.getPreferredStyle(((VexDocumentContentModel)documentContentModel).getDocumentType());
        }
        if (style == null) {
            return StyleSheet.NULL;
        }
        return style.getStyleSheet();
    }
}

