/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.osgi.framework.Bundle;

public class BuildProblemDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "org.eclipse.vex.ui.config.buildProblemDecorator";
    private ImageDescriptor errorIcon;

    public void decorate(Object element, IDecoration decoration) {
        if (this.errorIcon == null) {
            this.loadImageDescriptors();
        }
        if (element instanceof IResource) {
            try {
                IResource resource = (IResource)element;
                IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                if (markers.length > 0) {
                    decoration.addOverlay(this.errorIcon, 2);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void update(IResource resource) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)resource));
    }

    public void update(IResource[] resources) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])resources));
    }

    private void loadImageDescriptors() {
        URL url = FileLocator.find((Bundle)VexPlugin.getDefault().getBundle(), (IPath)new Path("icons/error_co.gif"), null);
        this.errorIcon = ImageDescriptor.createFromURL((URL)url);
    }
}

