/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigPlugin;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationLoader;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.PluginProject;
import org.osgi.framework.Bundle;

public class ConfigLoaderJob
extends Job
implements ConfigurationLoader {
    private List<ConfigSource> loadedConfigSources = Collections.emptyList();

    public ConfigLoaderJob() {
        super(Messages.getString("ConfigLoaderJob.loadingConfig"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        int pluginCount = Platform.getExtensionRegistry().getNamespaces().length;
        int projectCount = ResourcesPlugin.getWorkspace().getRoot().getProjects().length;
        monitor.beginTask(Messages.getString("ConfigLoaderJob.loadingConfig"), pluginCount + projectCount);
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        result.addAll(ConfigLoaderJob.loadPlugins(monitor));
        result.addAll(ConfigLoaderJob.loadPluginProjects(monitor));
        ConfigLoaderJob configLoaderJob = this;
        synchronized (configLoaderJob) {
            this.loadedConfigSources = result;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private static List<ConfigSource> loadPlugins(IProgressMonitor monitor) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        String[] stringArray = extensionRegistry.getNamespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)namespace);
            if (bundle != null) {
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                monitor.subTask(String.valueOf(Messages.getString("ConfigLoaderJob.loading")) + name);
                ConfigPlugin configPlugin = new ConfigPlugin(namespace);
                if (!configPlugin.isEmpty()) {
                    result.add(configPlugin);
                }
                monitor.worked(1);
            }
            ++n2;
        }
        return result;
    }

    private static List<ConfigSource> loadPluginProjects(IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PluginProject.isOpenPluginProject(project)) {
                monitor.subTask(String.valueOf(Messages.getString("ConfigLoaderJob.loadingProject")) + project.getName());
                PluginProject pluginProject = new PluginProject(project);
                try {
                    pluginProject.load();
                    result.add(pluginProject);
                }
                catch (CoreException e) {
                    VexPlugin.getDefault().getLog().log(e.getStatus());
                }
                monitor.worked(1);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public synchronized List<ConfigSource> getLoadedConfigSources() {
        return this.loadedConfigSources;
    }

    @Override
    public boolean isLoading() {
        return this.getState() == 4 || this.getState() == 2;
    }

    @Override
    public void load(final Runnable whenDone) {
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ConfigLoaderJob.this.removeJobChangeListener((IJobChangeListener)this);
                whenDone.run();
            }
        });
        this.schedule();
    }
}

