/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.DoctypeFactory;
import org.eclipse.vex.ui.internal.config.IBuildProblemHandler;
import org.eclipse.vex.ui.internal.config.IConfigElement;
import org.eclipse.vex.ui.internal.config.IConfigItemFactory;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.StyleFactory;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;

public abstract class ConfigSource {
    private static final IConfigItemFactory[] CONFIG_ITEM_FACTORIES = new IConfigItemFactory[]{new DoctypeFactory(), new StyleFactory()};
    private final String id;
    private final List<ConfigItem> items = new ArrayList<ConfigItem>();
    private final Map<URI, Object> parsedResources = new HashMap<URI, Object>();

    protected static IConfigItemFactory getConfigItemFactory(String extensionPointId) {
        IConfigItemFactory[] iConfigItemFactoryArray = CONFIG_ITEM_FACTORIES;
        int n = CONFIG_ITEM_FACTORIES.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigItemFactory factory = iConfigItemFactoryArray[n2];
            if (factory.getExtensionPointId().equals(extensionPointId)) {
                return factory;
            }
            ++n2;
        }
        return null;
    }

    public ConfigSource(String id) {
        this.id = id;
    }

    public void addItem(ConfigItem item) {
        this.items.add(item);
        this.parseResources(null);
    }

    protected ConfigItem addItem(String extensionPoint, String simpleIdentifier, String name, IConfigElement[] configElements) throws IOException {
        IConfigItemFactory factory = ConfigSource.getConfigItemFactory(extensionPoint);
        if (factory == null) {
            return null;
        }
        ConfigItem item = factory.createItem(this, configElements);
        item.setSimpleId(simpleIdentifier);
        item.setName(name);
        this.addItem(item);
        return item;
    }

    public void remove(ConfigItem item) {
        this.items.remove(item);
    }

    public void removeAllItems() {
        this.items.clear();
    }

    public void removeAllResources() {
        this.parsedResources.clear();
    }

    public void removeResource(String uri) {
        this.parsedResources.remove(uri);
    }

    public List<ConfigItem> getAllItems() {
        return this.items;
    }

    public abstract URL getBaseUrl();

    public ConfigItem getItem(String simpleId) {
        for (ConfigItem item : this.items) {
            if (item.getSimpleId() == null || !item.getSimpleId().equals(simpleId)) continue;
            return item;
        }
        return null;
    }

    public ConfigItem getItemForResource(IResource resource) {
        for (ConfigItem item : this.items) {
            if (!item.getResourceUri().equals(resource.getLocationURI())) continue;
            return item;
        }
        return null;
    }

    public Object getParsedResource(URI uri) {
        return this.parsedResources.get(uri);
    }

    public String getUniqueIdentifer() {
        return this.id;
    }

    public Collection<ConfigItem> getValidItems(String extensionPointId) {
        ArrayList<ConfigItem> result = new ArrayList<ConfigItem>();
        for (ConfigItem item : this.items) {
            if (!item.getExtensionPointId().equals(extensionPointId) || !item.isValid()) continue;
            result.add(item);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void parseResources(IBuildProblemHandler problemHandler) {
        this.parsedResources.clear();
        for (ConfigItem item : this.items) {
            URI uri = item.getResourceUri();
            if (uri == null || this.parsedResources.containsKey(uri)) continue;
            IConfigItemFactory factory = ConfigSource.getConfigItemFactory(item.getExtensionPointId());
            try {
                Object parsedResource = factory.parseResource(item, this.getBaseUrl(), uri.toString(), problemHandler);
                if (parsedResource == null) continue;
                this.parsedResources.put(uri, parsedResource);
            }
            catch (IOException ex) {
                String message = MessageFormat.format(Messages.getString("ConfigSource.errorParsingUri"), uri);
                VexPlugin.getDefault().log(4, message, ex);
            }
        }
    }

    public String resolve(String publicId, String systemId) {
        URIResolver uriResolver = URIResolverPlugin.createResolver();
        return uriResolver.resolve(this.getBaseUrl().toString(), publicId, systemId);
    }
}

