/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.vex.core.internal.validator.WTPVEXValidator;
import org.eclipse.vex.core.provisional.dom.DocumentContentModel;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationElement;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IBuildProblemHandler;
import org.eclipse.vex.ui.internal.config.IConfigElement;
import org.eclipse.vex.ui.internal.config.IConfigItemFactory;
import org.eclipse.vex.ui.internal.config.Messages;

public class DoctypeFactory
implements IConfigItemFactory {
    private static final String[] EXTS = new String[]{"dtd"};
    private static final String ELT_DOCTYPE = "doctype";
    private static final String ATTR_OUTLINE_PROVIDER = "outlineProvider";
    private static final String ATTR_SYSTEM_ID = "systemId";
    private static final String ATTR_PUBLIC_ID = "publicId";
    private static final String ATTR_NAMESPACE_NAME = "namespaceName";
    private static final String ELT_ROOT_ELEMENT = "rootElement";
    private static final String ATTR_NAME = "name";

    @Override
    public IConfigElement[] createConfigurationElements(ConfigItem item) {
        DocumentType doctype = (DocumentType)item;
        ConfigurationElement doctypeElement = new ConfigurationElement(ELT_DOCTYPE);
        doctypeElement.setAttribute(ATTR_PUBLIC_ID, doctype.getPublicId());
        doctypeElement.setAttribute(ATTR_SYSTEM_ID, doctype.getSystemId());
        doctypeElement.setAttribute(ATTR_OUTLINE_PROVIDER, doctype.getOutlineProvider());
        String[] stringArray = doctype.getRootElements();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ConfigurationElement rootElement = new ConfigurationElement(ELT_ROOT_ELEMENT);
            rootElement.setAttribute(ATTR_NAME, name);
            doctypeElement.addChild(rootElement);
            ++n2;
        }
        return new IConfigElement[]{doctypeElement};
    }

    @Override
    public ConfigItem createItem(ConfigSource config, IConfigElement[] configElements) throws IOException {
        if (configElements.length < 1) {
            return null;
        }
        DocumentType doctype = new DocumentType(config);
        IConfigElement configElement = configElements[0];
        if (configElement.getName() == null) {
            System.out.println("configElement:" + configElement.getName());
        }
        if (configElement.getName().equals(ELT_DOCTYPE)) {
            String publicId = configElement.getAttribute(ATTR_PUBLIC_ID);
            String systemId = configElement.getAttribute(ATTR_SYSTEM_ID);
            doctype.setPublicId(publicId);
            doctype.setSystemId(systemId);
            doctype.setResourceUri(DoctypeFactory.newUri(config.resolve(publicId, systemId)));
        } else {
            String namespaceName = configElement.getAttribute(ATTR_NAMESPACE_NAME);
            doctype.setNamespaceName(namespaceName);
            doctype.setResourceUri(DoctypeFactory.newUri(config.resolve(null, namespaceName)));
        }
        doctype.setOutlineProvider(configElement.getAttribute(ATTR_OUTLINE_PROVIDER));
        IConfigElement[] rootElementRefs = configElement.getChildren();
        String[] rootElements = new String[rootElementRefs.length];
        int i = 0;
        while (i < rootElementRefs.length) {
            rootElements[i] = rootElementRefs[i].getAttribute(ATTR_NAME);
            ++i;
        }
        doctype.setRootElements(rootElements);
        return doctype;
    }

    private static URI newUri(String uriString) {
        try {
            return new URI(uriString.replaceAll(" ", "%20"));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public String getExtensionPointId() {
        return "org.eclipse.vex.ui.doctypes";
    }

    @Override
    public String[] getFileExtensions() {
        return EXTS;
    }

    @Override
    public String getPluralName() {
        return Messages.getString("DoctypeFactory.pluralName");
    }

    @Override
    public Object parseResource(ConfigItem item, URL baseUrl, String resourcePath, IBuildProblemHandler problemHandler) throws IOException {
        DocumentType documentType = (DocumentType)item;
        DocumentContentModel documentContentModel = new DocumentContentModel(baseUrl.toString(), documentType.getPublicId(), documentType.getSystemId(), null);
        return new WTPVEXValidator(documentContentModel);
    }
}

