/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import org.eclipse.vex.core.provisional.dom.IValidator;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;

public class DocumentType
extends ConfigItem {
    public static final String EXTENSION_POINT = "org.eclipse.vex.ui.doctypes";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String publicId;
    private String systemId;
    private String namespaceName;
    private String outlineProvider;
    private String[] rootElements = EMPTY_STRING_ARRAY;

    public DocumentType(ConfigSource config) {
        super(config);
    }

    public String getOutlineProvider() {
        return this.outlineProvider;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMainId() {
        if (!this.isBlank(this.publicId)) {
            return this.publicId;
        }
        if (!this.isBlank(this.namespaceName)) {
            return this.namespaceName;
        }
        if (!this.isBlank(this.systemId)) {
            return this.systemId;
        }
        return "";
    }

    @Override
    public String getExtensionPointId() {
        return EXTENSION_POINT;
    }

    public void setOutlineProvider(String contentOutlinePage) {
        this.outlineProvider = contentOutlinePage;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public IValidator getValidator() {
        return (IValidator)this.getConfig().getParsedResource(this.getResourceUri());
    }

    @Override
    public boolean isValid() {
        boolean doctypeValid;
        boolean bl = doctypeValid = !this.isBlank(this.publicId) && !this.isBlank(this.systemId) || !this.isBlank(this.namespaceName);
        return super.isValid() && doctypeValid && this.getValidator() != null;
    }

    public String toString() {
        return this.getName();
    }

    public String[] getRootElements() {
        return this.rootElements;
    }

    public void setRootElements(String[] rootElements) {
        if (rootElements == null) {
            throw new IllegalArgumentException();
        }
        this.rootElements = rootElements;
    }
}

