/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.Messages;

public class NewPluginProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IWorkbench workbench;
    private IConfigurationElement configurationElement;
    private WizardNewProjectCreationPage mainPage;
    private WizardNewProjectReferencePage referencePage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(Messages.getString("NewPluginProjectWizard.title"));
    }

    public void setInitializationData(IConfigurationElement configurationElement, String propertyName, Object data) throws CoreException {
        this.configurationElement = configurationElement;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("NewPluginProjectPage");
        this.mainPage.setTitle("Project");
        this.mainPage.setDescription("Create a plug-in project.");
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("ReferenceProjectPage");
            this.referencePage.setTitle("Project References");
            this.referencePage.setDescription("Select referenced projects.");
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public boolean performFinish() {
        IProject newProject = this.createNewProject();
        if (newProject == null) {
            return false;
        }
        IWorkingSet[] workingSets = this.mainPage.getSelectedWorkingSets();
        this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)newProject, workingSets);
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        try {
            this.createVexPluginXml(newProject);
            this.registerVexPluginNature(newProject);
        }
        catch (CoreException e) {
            VexPlugin.getDefault().log(4, Messages.getString("NewPluginProjectWizard.createError"), e);
            return false;
        }
        return true;
    }

    private IProject createNewProject() {
        IProject[] refProjects;
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = !this.mainPage.useDefaults() ? this.mainPage.getLocationURI() : null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        IRunnableWithProgress createOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation createProject = new CreateProjectOperation(description, Messages.getString("NewPluginProjectWizard.title"));
                try {
                    createProject.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewPluginProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, createOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "org.eclipse.vex.ui", MessageFormat.format("The underlying file system is case insensitive. There is an existing project or directory that conflicts with ''{0}''.", newProjectHandle.getName()), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "org.eclipse.vex.ui", "Creation Problems", (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)"Creation Problems");
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.vex.ui", 0, MessageFormat.format("Internal error: {0}", t.getMessage()), t));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)"Creation Problems");
                StatusManager.getManager().handle(status, 5);
            }
            return null;
        }
        return newProjectHandle;
    }

    private void createVexPluginXml(IProject project) throws CoreException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buffer);
        out.println("<?xml version='1.0'?>");
        out.println("<plugin>");
        out.println("</plugin>");
        out.close();
        IFile pluginXml = project.getFile("vex-plugin.xml");
        pluginXml.create((InputStream)new ByteArrayInputStream(buffer.toByteArray()), true, null);
        IDE.setDefaultEditor((IFile)pluginXml, (String)"org.eclipse.ui.DefaultTextEditor");
    }

    private void registerVexPluginNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.vex.ui.pluginNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

