/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vex.core.internal.io.DocumentWriter;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.BuildProblem;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationElement;
import org.eclipse.vex.ui.internal.config.DomConfigurationElement;
import org.eclipse.vex.ui.internal.config.IBuildProblemHandler;
import org.eclipse.vex.ui.internal.config.IConfigElement;
import org.eclipse.vex.ui.internal.config.IConfigItemFactory;
import org.eclipse.vex.ui.internal.config.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginProject
extends ConfigSource {
    public static final String PLUGIN_XML = "vex-plugin.xml";
    private final IProject project;

    public PluginProject(IProject project) {
        super(project.getName());
        this.project = project;
    }

    @Override
    public URL getBaseUrl() {
        return PluginProject.toURL((IResource)this.getProject());
    }

    private static URL toURL(IResource resource) {
        try {
            return resource.getLocation().toFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void build() {
        try {
            this.project.build(6, null);
        }
        catch (CoreException e) {
            String message = MessageFormat.format(Messages.getString("PluginProject.buildError"), this.project.getName());
            VexPlugin.getDefault().log(4, message, e);
        }
    }

    public void load() throws CoreException {
        this.checkProject();
        this.parseConfigXml(null);
        this.parseResources(null);
    }

    private void checkProject() {
        if (!PluginProject.isOpenPluginProject(this.project)) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("PluginProject.notPluginProject"), this.project.getName()));
        }
    }

    public static boolean isOpenPluginProject(IProject project) {
        return project.isOpen() && PluginProject.hasPluginProjectNature(project);
    }

    public static boolean hasPluginProjectNature(IProject project) {
        try {
            return project.isOpen() && project.hasNature("org.eclipse.vex.ui.pluginNature");
        }
        catch (CoreException e) {
            VexPlugin.getDefault().getLog().log(e.getStatus());
            return false;
        }
    }

    public void parseConfigXml(IBuildProblemHandler problemHandler) throws CoreException {
        this.removeAllItems();
        Document document = this.parseConfigXmlDom(problemHandler);
        if (document == null) {
            return;
        }
        NodeList extensions = document.getElementsByTagName("extension");
        int i = 0;
        while (i < extensions.getLength()) {
            Element extensionElement = (Element)extensions.item(i);
            String extensionPointId = extensionElement.getAttribute("point");
            String id = extensionElement.getAttribute("id");
            String name = extensionElement.getAttribute("name");
            IConfigElement[] configElements = this.parseConfigElements(extensionElement);
            try {
                this.addItem(extensionPointId, id, name, configElements);
            }
            catch (IOException e) {
                VexPlugin.getDefault().log(4, e.getMessage(), e);
            }
            ++i;
        }
    }

    private Document parseConfigXmlDom(IBuildProblemHandler problemHandler) throws CoreException {
        IFile configXml = this.project.getFile(PLUGIN_XML);
        DocumentBuilder builder = PluginProject.createDocumentBuilder();
        try {
            URL url = PluginProject.toURL((IResource)configXml);
            return builder.parse(url.toString());
        }
        catch (SAXParseException e) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem(1, configXml.getName(), e.getMessage(), e.getLineNumber());
                problemHandler.foundProblem(problem);
                return null;
            }
            VexPlugin.getDefault().log(4, MessageFormat.format("Cannot load {0}.", configXml.getFullPath()), e);
            return null;
        }
        catch (SAXException e) {
            VexPlugin.getDefault().log(4, MessageFormat.format("Cannot load {0}.", configXml.getFullPath()), e);
            return null;
        }
        catch (IOException e) {
            VexPlugin.getDefault().log(4, MessageFormat.format("Cannot load {0}.", configXml.getFullPath()), e);
            return null;
        }
    }

    private IConfigElement[] parseConfigElements(Element extensionElement) {
        ArrayList<DomConfigurationElement> result = new ArrayList<DomConfigurationElement>();
        NodeList childList = extensionElement.getChildNodes();
        int j = 0;
        while (j < childList.getLength()) {
            Node child = childList.item(j);
            if (child instanceof Element) {
                result.add(new DomConfigurationElement((Element)child));
            }
            ++j;
        }
        return result.toArray(new IConfigElement[result.size()]);
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        catch (FactoryConfigurationError e) {
            throw new AssertionError((Object)e);
        }
    }

    public void writeConfigXml() throws CoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "utf-8"));
        ConfigurationElement root = new ConfigurationElement("plugin");
        for (ConfigItem item : this.getAllItems()) {
            ConfigurationElement extElement = new ConfigurationElement("extension");
            extElement.setAttribute("id", item.getSimpleId());
            extElement.setAttribute("name", item.getName());
            extElement.setAttribute("point", item.getExtensionPointId());
            IConfigItemFactory factory = PluginProject.getConfigItemFactory(item.getExtensionPointId());
            if (factory == null) continue;
            extElement.setChildren(factory.createConfigurationElements(item));
            root.addChild(extElement);
        }
        PluginProject.writeElement(root, out, 0);
        out.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        IFile file = this.getProject().getFile(PLUGIN_XML);
        if (file.exists()) {
            file.setContents((InputStream)inputStream, true, false, null);
        } else {
            file.create((InputStream)inputStream, true, null);
        }
    }

    private static void writeElement(IConfigElement element, PrintWriter out, int level) {
        IConfigElement[] children;
        StringBuffer elementIndent = new StringBuffer();
        int i = 0;
        while (i < level) {
            elementIndent.append("  ");
            ++i;
        }
        StringBuffer elementPrefix = new StringBuffer();
        elementPrefix.append("<");
        elementPrefix.append(element.getName());
        StringBuffer attributeIndent = new StringBuffer(elementIndent.toString());
        int i2 = 0;
        while (i2 < elementPrefix.length() + 1) {
            attributeIndent.append(" ");
            ++i2;
        }
        out.print(elementIndent.toString());
        out.print(elementPrefix.toString());
        String[] attributeNames = element.getAttributeNames();
        int i3 = 0;
        while (i3 < attributeNames.length) {
            String attributeName = attributeNames[i3];
            if (i3 > 0) {
                out.println();
                out.print(attributeIndent);
            } else {
                out.print(" ");
            }
            out.print(attributeName);
            out.print("=\"");
            out.print(DocumentWriter.escape((String)element.getAttribute(attributeName)));
            out.print("\"");
            ++i3;
        }
        out.println(">");
        IConfigElement[] iConfigElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigElement element2 = iConfigElementArray[n2];
            PluginProject.writeElement(element2, out, level + 1);
            ++n2;
        }
        out.print(elementIndent);
        out.print("</");
        out.print(element.getName());
        out.println(">");
    }
}

