/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.BuildProblem;
import org.eclipse.vex.ui.internal.config.BuildProblemDecorator;
import org.eclipse.vex.ui.internal.config.IBuildProblemHandler;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.PluginProject;

public class PluginProjectBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.vex.ui.pluginBuilder";
    final IBuildProblemHandler buildProblemHandler = new IBuildProblemHandler(){

        @Override
        public void foundProblem(BuildProblem problem) {
            try {
                IFile resource = PluginProjectBuilder.this.getProject().getFile(problem.getResourcePath());
                PluginProjectBuilder.markError((IResource)resource, problem.getMessage(), problem.getLineNumber());
            }
            catch (CoreException e) {
                VexPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    };

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IMarker[] oldMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        IResource[] markedResources = new IResource[oldMarkers.length];
        int i = 0;
        while (i < markedResources.length) {
            markedResources[i] = oldMarkers[i].getResource();
            ++i;
        }
        project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        PluginProjectBuilder.updateMarkedResourcesDecoration(markedResources);
        PluginProject pluginProject = new PluginProject(project);
        if (this.getProject().getFile("vex-plugin.xml").exists()) {
            pluginProject.parseConfigXml(this.buildProblemHandler);
        } else {
            String message = MessageFormat.format(Messages.getString("PluginProjectBuilder.missingFile"), "vex-plugin.xml");
            PluginProjectBuilder.markError((IResource)this.getProject(), message);
        }
        pluginProject.parseResources(this.buildProblemHandler);
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        VexPlugin.getDefault().getConfigurationRegistry().loadConfigurations();
    }

    private static void markError(IResource resource, String message) throws CoreException {
        PluginProjectBuilder.markError(resource, message, -1);
    }

    private static void markError(IResource resource, String message, int lineNumber) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        if (!marker.exists()) {
            return;
        }
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("priority", 2);
        marker.setAttribute("severity", 2);
        if (lineNumber > 0) {
            marker.setAttribute("lineNumber", lineNumber);
        }
        PluginProjectBuilder.updateMarkedResourcesDecoration(resource);
    }

    private static void updateMarkedResourcesDecoration(IResource ... resources) {
        PluginProjectBuilder.getBuildProblemDecorator().update(resources);
    }

    private static BuildProblemDecorator getBuildProblemDecorator() {
        IDecoratorManager decorationManager = PlatformUI.getWorkbench().getDecoratorManager();
        return (BuildProblemDecorator)decorationManager.getBaseLabelProvider("org.eclipse.vex.ui.config.buildProblemDecorator");
    }
}

