/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.osgi.framework.Bundle;

public class PluginProjectDecorator
implements ILightweightLabelDecorator {
    private ImageDescriptor vexIcon;

    public void decorate(Object element, IDecoration decoration) {
        if (this.vexIcon == null) {
            this.loadImageDescriptors();
        }
        if (element instanceof IProject) {
            try {
                IProject project = (IProject)element;
                if (project.hasNature("org.eclipse.vex.ui.pluginNature")) {
                    decoration.addOverlay(this.vexIcon, 1);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private void loadImageDescriptors() {
        URL url = FileLocator.find((Bundle)VexPlugin.getDefault().getBundle(), (IPath)new Path("icons/vex8.gif"), null);
        this.vexIcon = ImageDescriptor.createFromURL((URL)url);
    }
}

