/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.layout.BoxFactory;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;

public class Style
extends ConfigItem {
    public static final String EXTENSION_POINT = "org.eclipse.vex.ui.styles";
    private BoxFactory boxFactory;
    private final Set<String> publicIds = new HashSet<String>();

    public Style(ConfigSource config) {
        super(config);
    }

    public void addDocumentType(String publicId) {
        this.publicIds.add(publicId);
    }

    public boolean appliesTo(String publicId) {
        return this.publicIds.contains(publicId);
    }

    public BoxFactory getBoxFactory() {
        return this.boxFactory;
    }

    public Set<String> getDocumentTypes() {
        return Collections.unmodifiableSet(this.publicIds);
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getConfig().getParsedResource(this.getResourceUri());
    }

    @Override
    public String getExtensionPointId() {
        return EXTENSION_POINT;
    }

    public void removeAllDocumentTypes() {
        this.publicIds.clear();
    }

    public void removeDocumentType(String publicId) {
        this.publicIds.remove(publicId);
    }

    public void setBoxFactory(BoxFactory factory) {
        this.boxFactory = factory;
    }
}

