/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.contenttype;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class InferXmlContentTypeHandler
extends DefaultHandler
implements LexicalHandler {
    private String dtdPublicId;
    private String dtdSystemId;
    private QualifiedName rootElementName;

    public String getMainDocumentTypeIdentifier() {
        if (this.dtdPublicId != null) {
            return this.dtdPublicId;
        }
        if (this.dtdSystemId != null) {
            return this.dtdSystemId;
        }
        return this.rootElementName.getQualifier();
    }

    public QualifiedName getRootElementName() {
        return this.rootElementName;
    }

    public boolean parseContents(InputSource contents) {
        SAXParserFactory factory;
        block6: {
            factory = SAXParserFactory.newInstance();
            if (factory != null) break block6;
            return false;
        }
        try {
            factory.setNamespaceAware(true);
            SAXParser parser = this.createParser(factory);
            contents.setSystemId("/");
            parser.parse(contents, (DefaultHandler)this);
        }
        catch (AbortParsingException abortParsingException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        return parser;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtdPublicId = publicId;
        this.dtdSystemId = systemId;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.rootElementName = new QualifiedName(uri, localName);
        throw new AbortParsingException();
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new StringReader(""));
    }

    private static class AbortParsingException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        private AbortParsingException() {
        }
    }
}

