/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.contenttype.InferXmlContentTypeHandler;
import org.xml.sax.InputSource;

public class VexContentDescriber
extends XMLContentDescriber {
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), description);
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), description);
    }

    private int checkCriteria(InputSource contents, IContentDescription description) {
        InferXmlContentTypeHandler handler = new InferXmlContentTypeHandler();
        if (!handler.parseContents(contents)) {
            return 0;
        }
        DocumentType documentType = VexPlugin.getDefault().getConfigurationRegistry().getDocumentType(handler.getMainDocumentTypeIdentifier(), "");
        if (documentType != null) {
            return 2;
        }
        return 1;
    }
}

