/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.BaseNodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IComment;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IProcessingInstruction;
import org.eclipse.vex.core.provisional.dom.IText;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public class DocumentContextSourceProvider
extends AbstractSourceProvider {
    public static final String IS_COLUMN = "org.eclipse.vex.ui.isColumn";
    public static final String IS_FIRST_COLUMN = "org.eclipse.vex.ui.isFirstColumn";
    public static final String IS_LAST_COLUMN = "org.eclipse.vex.ui.isLastColumn";
    public static final String IS_ROW = "org.eclipse.vex.ui.isRow";
    public static final String IS_FIRST_ROW = "org.eclipse.vex.ui.isFirstRow";
    public static final String IS_LAST_ROW = "org.eclipse.vex.ui.isLastRow";
    public static final String IS_ELEMENT = "org.eclipse.vex.ui.isElement";
    public static final String IS_COMMENT = "org.eclipse.vex.ui.isComment";
    public static final String IS_PROCESSING_INSTRUCTION = "org.eclipse.vex.ui.isProcessingInstruction";
    private boolean isColumn;
    private boolean isFirstColumn;
    private boolean isLastColumn;
    private boolean isRow;
    private boolean isFirstRow;
    private boolean isLastRow;
    private boolean isElement;
    private boolean isComment;
    private boolean isProcessingInstruction;
    private INode currentNode;
    private final INodeVisitorWithResult<Map<String, Boolean>> nodeTypeVisitor = new BaseNodeVisitorWithResult<Map<String, Boolean>>(new HashMap()){

        public Map<String, Boolean> visit(IElement element) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(3);
            result.put(DocumentContextSourceProvider.IS_ELEMENT, true);
            result.put(DocumentContextSourceProvider.IS_COMMENT, false);
            result.put(DocumentContextSourceProvider.IS_PROCESSING_INSTRUCTION, false);
            return result;
        }

        public Map<String, Boolean> visit(IComment comment) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(3);
            result.put(DocumentContextSourceProvider.IS_ELEMENT, false);
            result.put(DocumentContextSourceProvider.IS_COMMENT, true);
            result.put(DocumentContextSourceProvider.IS_PROCESSING_INSTRUCTION, false);
            return result;
        }

        public Map<String, Boolean> visit(IProcessingInstruction pi) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(3);
            result.put(DocumentContextSourceProvider.IS_ELEMENT, false);
            result.put(DocumentContextSourceProvider.IS_COMMENT, false);
            result.put(DocumentContextSourceProvider.IS_PROCESSING_INSTRUCTION, true);
            return result;
        }

        public Map<String, Boolean> visit(IText text) {
            return (Map)text.getParent().accept((INodeVisitorWithResult)this);
        }
    };

    public void dispose() {
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_COLUMN};
    }

    public Map<String, Boolean> getCurrentState() {
        HashMap<String, Boolean> currentState = new HashMap<String, Boolean>(6);
        currentState.put(IS_COLUMN, this.isColumn);
        currentState.put(IS_FIRST_COLUMN, this.isFirstColumn);
        currentState.put(IS_LAST_COLUMN, this.isLastColumn);
        currentState.put(IS_ROW, this.isRow);
        currentState.put(IS_FIRST_ROW, this.isFirstRow);
        currentState.put(IS_LAST_ROW, this.isLastRow);
        currentState.put(IS_ELEMENT, this.isElement);
        currentState.put(IS_COMMENT, this.isComment);
        currentState.put(IS_PROCESSING_INSTRUCTION, this.isProcessingInstruction);
        return currentState;
    }

    public void fireUpdate(VexWidget widget) {
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        VexHandlerUtil.RowColumnInfo rowColumnInfo = VexHandlerUtil.getRowColumnInfo((IVexWidget)widget);
        int columnIndex = VexHandlerUtil.getCurrentColumnIndex((IVexWidget)widget);
        int columnCount = rowColumnInfo == null ? -1 : rowColumnInfo.maxColumnCount;
        this.isColumn = DocumentContextSourceProvider.update(changes, this.isColumn, columnIndex != -1, IS_COLUMN);
        this.isFirstColumn = DocumentContextSourceProvider.update(changes, this.isFirstColumn, columnIndex == 0, IS_FIRST_COLUMN);
        this.isLastColumn = DocumentContextSourceProvider.update(changes, this.isLastColumn, columnIndex == columnCount - 1, IS_LAST_COLUMN);
        int rowCount = rowColumnInfo == null ? -1 : rowColumnInfo.rowCount;
        int rowIndex = rowColumnInfo == null ? -1 : rowColumnInfo.rowIndex;
        this.isRow = DocumentContextSourceProvider.update(changes, this.isRow, rowIndex != -1, IS_ROW);
        this.isFirstRow = DocumentContextSourceProvider.update(changes, this.isFirstRow, rowIndex == 0, IS_FIRST_ROW);
        this.isLastRow = DocumentContextSourceProvider.update(changes, this.isLastRow, rowIndex == rowCount - 1, IS_LAST_ROW);
        INode selectedNode = widget.getCurrentNode();
        if (!selectedNode.equals(this.currentNode)) {
            this.currentNode = selectedNode;
            changes.putAll((Map)this.currentNode.accept(this.nodeTypeVisitor));
        }
        if (!changes.isEmpty()) {
            this.fireSourceChanged(0, changes);
        }
    }

    private static boolean update(Map<String, Boolean> changes, boolean oldValue, boolean newValue, String valueName) {
        if (newValue == oldValue) {
            return oldValue;
        }
        changes.put(valueName, newValue);
        return newValue;
    }
}

