/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentInputReader
extends Reader {
    private final IDocument document;
    private int position;
    private final int documentLength;

    public DocumentInputReader(IDocument document) {
        this.document = document;
        this.documentLength = document.getLength();
        this.position = 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] cbuf, int off, int length) throws IOException {
        int charsRead = 0;
        while (charsRead < length && this.position < this.documentLength) {
            try {
                char c = this.document.getChar(this.position++);
                cbuf[off + charsRead++] = c;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        if (charsRead == 0) {
            return -1;
        }
        return charsRead;
    }
}

