/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vex.core.provisional.dom.IValidator;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;

public class DocumentTypeSelectionPage
extends WizardPage {
    private static final String SETTINGS_PUBLIC_ID = "publicId";
    private static final String SETTINGS_ROOT_ELEMENT_PREFIX = "root.";
    private IDialogSettings settings;
    private final DocumentType[] doctypes;
    private Combo typeCombo;
    private Combo elementCombo;
    private final SelectionListener typeComboSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            DocumentTypeSelectionPage.this.updateRootElementCombo();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private final SelectionListener elementComboSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            DocumentTypeSelectionPage.this.setPageComplete(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public DocumentTypeSelectionPage() {
        super(Messages.getString("DocumentTypeSelectionPage.pageName"));
        this.setPageComplete(false);
        IDialogSettings rootSettings = VexPlugin.getDefault().getDialogSettings();
        this.settings = rootSettings.getSection("newDocument");
        if (this.settings == null) {
            this.settings = rootSettings.addNewSection("newDocument");
        }
        this.doctypes = VexPlugin.getDefault().getConfigurationRegistry().getDocumentTypesWithStyles();
        Arrays.sort(this.doctypes);
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pane.setLayout((Layout)layout);
        Label label = new Label(pane, 0);
        label.setText(Messages.getString("DocumentTypeSelectionPage.doctype"));
        this.typeCombo = new Combo(pane, 12);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.addSelectionListener(this.typeComboSelectionListener);
        label = new Label(pane, 0);
        label.setText(Messages.getString("DocumentTypeSelectionPage.rootElement"));
        this.setControl((Control)pane);
        this.elementCombo = new Combo(pane, 12);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.elementCombo.setLayoutData((Object)gd);
        this.elementCombo.addSelectionListener(this.elementComboSelectionListener);
        String publicId = this.settings.get(SETTINGS_PUBLIC_ID);
        int initSelection = -1;
        String[] typeNames = new String[this.doctypes.length];
        int i = 0;
        while (i < this.doctypes.length) {
            typeNames[i] = this.doctypes[i].getName();
            if (this.doctypes[i].getMainId().equals(publicId)) {
                initSelection = i;
            }
            ++i;
        }
        this.typeCombo.setItems(typeNames);
        if (initSelection != -1) {
            this.typeCombo.select(initSelection);
            this.updateRootElementCombo();
        }
        this.setTitle(Messages.getString("DocumentTypeSelectionPage.title"));
        this.setDescription(Messages.getString("DocumentTypeSelectionPage.desc"));
    }

    public DocumentType getDocumentType() {
        int i = this.typeCombo.getSelectionIndex();
        if (i == -1) {
            return null;
        }
        return this.doctypes[i];
    }

    public String getRootElementName() {
        return this.elementCombo.getText();
    }

    public void saveSettings() {
        DocumentType doctype = this.getDocumentType();
        if (doctype != null) {
            this.settings.put(SETTINGS_PUBLIC_ID, doctype.getPublicId());
            String key = SETTINGS_ROOT_ELEMENT_PREFIX + doctype.getPublicId();
            this.settings.put(key, this.getRootElementName());
        }
    }

    private void updateRootElementCombo() {
        DocumentType documentType = this.getDocumentType();
        Object[] rootElements = DocumentTypeSelectionPage.getRootElements(documentType);
        Arrays.sort(rootElements);
        this.elementCombo.removeAll();
        this.elementCombo.setItems((String[])rootElements);
        String key = SETTINGS_ROOT_ELEMENT_PREFIX + documentType.getPublicId();
        String selectedRoot = this.settings.get(key);
        this.setPageComplete(false);
        if (selectedRoot != null) {
            int i = 0;
            while (i < rootElements.length) {
                if (((String)rootElements[i]).equals(selectedRoot)) {
                    this.elementCombo.select(i);
                    this.setPageComplete(true);
                    break;
                }
                ++i;
            }
        }
    }

    private static String[] getRootElements(DocumentType documentType) {
        String[] selectedRootElements = documentType.getRootElements();
        if (selectedRootElements != null) {
            return selectedRootElements;
        }
        return DocumentTypeSelectionPage.getPossibleRootElements(documentType);
    }

    private static String[] getPossibleRootElements(DocumentType documentType) {
        IValidator validator = documentType.getValidator();
        if (validator == null) {
            return new String[0];
        }
        Set validRootElements = validator.getValidRootElements();
        String[] result = new String[validRootElements.size()];
        int i = 0;
        for (QualifiedName validRootElementName : validRootElements) {
            result[i++] = validRootElementName.getLocalName();
        }
        return result;
    }
}

