/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.vex.core.provisional.dom.DocumentContentModel;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.DocumentTypeSelectionDialog;
import org.eclipse.vex.ui.internal.editor.NoRegisteredDoctypeException;
import org.eclipse.vex.ui.internal.editor.NoStyleForDoctypeException;

public class VexDocumentContentModel
extends DocumentContentModel {
    private final Shell shell;
    private DocumentType documentType;
    private Style style;
    private boolean shouldAssignInferredDocumentType;

    public VexDocumentContentModel(Shell shell) {
        this.shell = shell;
    }

    public VexDocumentContentModel() {
        this.shell = null;
    }

    public void initialize(String baseUri, String publicId, String systemId, IElement rootElement) {
        super.initialize(baseUri, publicId, systemId, rootElement);
        String mainDocumentTypeIdentifier = this.getMainDocumentTypeIdentifier();
        this.documentType = this.getRegisteredDocumentType();
        if (this.documentType == null && this.shell != null) {
            this.documentType = this.queryUserForDocumentType();
            if (this.documentType == null) {
                throw new NoRegisteredDoctypeException(mainDocumentTypeIdentifier, false);
            }
            if (this.documentType.getNamespaceName() != null) {
                this.setSchemaId(baseUri, this.documentType.getNamespaceName());
            } else {
                super.initialize(baseUri, this.documentType.getPublicId(), this.documentType.getSystemId(), null);
            }
        }
        this.style = VexPlugin.getDefault().getPreferences().getPreferredStyle(this.getDocumentType());
        if (this.style == null) {
            throw new NoStyleForDoctypeException();
        }
    }

    private DocumentType getRegisteredDocumentType() {
        if (this.getMainDocumentTypeIdentifier() == null) {
            return null;
        }
        DocumentType doctype = VexPlugin.getDefault().getConfigurationRegistry().getDocumentType(this.getMainDocumentTypeIdentifier(), this.getSystemId());
        if (doctype != null) {
            return doctype;
        }
        return null;
    }

    private DocumentType queryUserForDocumentType() {
        DocumentTypeSelectionDialog dialog = DocumentTypeSelectionDialog.create(this.shell, this.getMainDocumentTypeIdentifier());
        if (dialog.open() == 1) {
            throw new NoRegisteredDoctypeException(null, true);
        }
        if (dialog.alwaysUseThisDoctype()) {
            this.shouldAssignInferredDocumentType = true;
        }
        return dialog.getDoctype();
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean shouldAssignInferredDocumentType() {
        return this.shouldAssignInferredDocumentType;
    }
}

