/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.vex.core.internal.core.ListenerList;
import org.eclipse.vex.core.internal.css.CssWhitespacePolicy;
import org.eclipse.vex.core.internal.css.IStyleSheetProvider;
import org.eclipse.vex.core.internal.dom.DocumentTextPosition;
import org.eclipse.vex.core.internal.io.DocumentReader;
import org.eclipse.vex.core.internal.io.DocumentWriter;
import org.eclipse.vex.core.internal.validator.WTPVEXValidator;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.AttributeChangeEvent;
import org.eclipse.vex.core.provisional.dom.BaseNodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.ContentChangeEvent;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.DocumentContentModel;
import org.eclipse.vex.core.provisional.dom.IComment;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IDocumentListener;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.IIncludeNode;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IProcessingInstruction;
import org.eclipse.vex.core.provisional.dom.IValidator;
import org.eclipse.vex.core.provisional.dom.NamespaceDeclarationChangeEvent;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.VexPreferences;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.AbstractRegExFindReplaceTarget;
import org.eclipse.vex.ui.internal.editor.DocumentContextSourceProvider;
import org.eclipse.vex.ui.internal.editor.DocumentInputReader;
import org.eclipse.vex.ui.internal.editor.IVexEditorListener;
import org.eclipse.vex.ui.internal.editor.NoRegisteredDoctypeException;
import org.eclipse.vex.ui.internal.editor.NoStyleForDoctypeException;
import org.eclipse.vex.ui.internal.editor.SelectionProvider;
import org.eclipse.vex.ui.internal.editor.VexDocumentContentModel;
import org.eclipse.vex.ui.internal.editor.VexEditorEvent;
import org.eclipse.vex.ui.internal.outline.DocumentOutlinePage;
import org.eclipse.vex.ui.internal.property.DocumentPropertySource;
import org.eclipse.vex.ui.internal.property.ElementPropertySource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class VexEditor
extends EditorPart {
    public static final String ID = "org.eclipse.vex.ui.internal.editor.VexEditor";
    private final boolean debugging;
    private final ConfigurationRegistry configurationRegistry;
    private final VexPreferences preferences;
    private Composite parentControl;
    private Text loadingLabel;
    private boolean loaded;
    private DocumentType doctype;
    private IDocument document;
    private Style style;
    private VexWidget vexWidget;
    private boolean dirty;
    private final ListenerList<IVexEditorListener, VexEditorEvent> vexEditorListeners = new ListenerList(IVexEditorListener.class);
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private IDocumentProvider documentProvider;
    private ActivationListener activationListener;
    private IElementStateListener elementStateListener = new ElementStateListener();
    private final org.eclipse.jface.text.IDocumentListener jFaceDocumentListener = new JFaceDocumentListener();
    private boolean handleActivation = true;
    private boolean handleDocumentChange = true;
    private boolean hasBeenActivated;
    private boolean externalModified = false;
    private boolean internalModified = false;
    private long docModificationStamp;
    private DocumentTextPosition positionOfCurrentNode = null;
    private final IConfigListener configListener = new IConfigListener(){

        @Override
        public void configChanged(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (VexEditor.this.style == null) {
                        return;
                    }
                    String styleId = VexEditor.this.style.getUniqueId();
                    Style newStyle = VexEditor.this.configurationRegistry.getStyle(styleId);
                    if (newStyle != null) {
                        VexEditor.this.vexWidget.setStyleSheet(newStyle.getStyleSheet());
                        VexEditor.this.style = newStyle;
                    }
                }
            });
        }

        @Override
        public void configLoaded(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    VexEditor.this.setInputFromProvider();
                }
            });
        }
    };
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            VexEditor.this.setStatus(VexEditor.this.getLocationPath());
            IEditorSite editorSite = VexEditor.this.getEditorSite();
            IWorkbenchWindow window = editorSite.getWorkbenchWindow();
            if (window instanceof IServiceLocator) {
                IWorkbenchWindow serviceLocator = window;
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                commandService.refreshElements("org.eclipse.vex.ui.ConvertElementCommand", null);
                commandService.refreshElements("org.eclipse.vex.ui.RemoveTagCommand", null);
            }
            ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
            DocumentContextSourceProvider contextProvider = (DocumentContextSourceProvider)service.getSourceProvider("org.eclipse.vex.ui.isColumn");
            contextProvider.fireUpdate(VexEditor.this.vexWidget);
        }
    };
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void attributeChanged(AttributeChangeEvent e) {
            VexEditor.this.setDirty();
        }

        public void namespaceChanged(NamespaceDeclarationChangeEvent e) {
            VexEditor.this.setDirty();
        }

        public void beforeContentDeleted(ContentChangeEvent e) {
        }

        public void beforeContentInserted(ContentChangeEvent e) {
        }

        public void contentDeleted(ContentChangeEvent e) {
            VexEditor.this.setDirty();
        }

        public void contentInserted(ContentChangeEvent e) {
            VexEditor.this.setDirty();
        }
    };
    private final INodeVisitorWithResult<String> nodePathVisitor = new BaseNodeVisitorWithResult<String>(""){

        public String visit(IElement element) {
            return element.getPrefixedName();
        }

        public String visit(IProcessingInstruction pi) {
            return Messages.getString("VexEditor.Path.ProcessingInstruction");
        }

        public String visit(IComment comment) {
            return Messages.getString("VexEditor.Path.Comment");
        }

        public String visit(IIncludeNode include) {
            return include.getReference().getPrefixedName();
        }
    };

    public VexEditor() {
        this.debugging = VexPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.vex.ui/debug/layout"));
        this.configurationRegistry = VexPlugin.getDefault().getConfigurationRegistry();
        this.preferences = VexPlugin.getDefault().getPreferences();
    }

    public void addVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.add((Object)listener);
    }

    public void dispose() {
        super.dispose();
        if (this.activationListener != null) {
            this.activationListener.dispose();
            this.activationListener = null;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionChangedListener);
        if (this.parentControl != null) {
            this.configurationRegistry.removeConfigListener(this.configListener);
        }
        this.disposeDocumentProvider();
    }

    public void doSave(IProgressMonitor monitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(monitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = Messages.getString("VexEditor.docDeleted.canNotSave.title");
                String msg = Messages.getString("VexEditor.docDeleted.canNotSave.title");
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.performSave(false, monitor);
        }
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        this.handleActivation = false;
        try {
            try {
                provider.aboutToChange((Object)this.getEditorInput());
                this.syncDocumentProvider();
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
            }
            catch (CoreException ex) {
                String title = Messages.getString("VexEditor.errorSaving.title");
                String message = MessageFormat.format(Messages.getString("VexEditor.errorSaving.message"), this.getEditorInput().getName(), ex.getMessage());
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                VexPlugin.getDefault().log(4, message, ex);
                provider.changed((Object)this.getEditorInput());
                this.setClean();
                this.handleActivation = true;
            }
        }
        finally {
            provider.changed((Object)this.getEditorInput());
            this.setClean();
            this.handleActivation = true;
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block26: {
            Object newInput;
            SaveAsDialog dialog;
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            IDocumentProvider provider = this.getDocumentProvider();
            IEditorInput input = this.getEditorInput();
            if (input instanceof IURIEditorInput && !(input instanceof IFileEditorInput)) {
                IFileStore fileStore;
                String message;
                String title;
                MessageDialog overwriteDialog;
                String path;
                dialog = new FileDialog(shell, 8192);
                IPath oldPath = URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
                if (oldPath != null) {
                    dialog.setFileName(oldPath.lastSegment());
                    dialog.setFilterPath(oldPath.toOSString());
                }
                if ((path = dialog.open()) == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                File localFile = new File(path);
                if (localFile.exists() && (overwriteDialog = new MessageDialog(shell, title = Messages.getString("VexEditor.saveAs.overwrite.title"), null, message = MessageFormat.format(Messages.getString("VexEditor.saveAs.overwrite.message"), path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                    return;
                }
                try {
                    fileStore = EFS.getStore((URI)localFile.toURI());
                }
                catch (CoreException ex) {
                    VexPlugin.getDefault().log(4, ex.getLocalizedMessage(), ex);
                    String title2 = Messages.getString("VexEditor.saveAs.error.title");
                    String msg = MessageFormat.format(Messages.getString("VexEditor.saveAs.error.message"), ex.getLocalizedMessage());
                    MessageDialog.openError((Shell)shell, (String)title2, (String)msg);
                    return;
                }
                IFile file = this.getWorkspaceFile(fileStore);
                newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
            } else {
                IFile original;
                dialog = new SaveAsDialog(shell);
                IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
                if (original != null) {
                    dialog.setOriginalFile(original);
                } else {
                    dialog.setOriginalName(input.getName());
                }
                dialog.create();
                if (provider.isDeleted((Object)input) && original != null) {
                    String msg = MessageFormat.format(Messages.getString("VexEditor.saveAs.deleted"), original.getName());
                    dialog.setErrorMessage(null);
                    dialog.setMessage(msg, 2);
                }
                if (dialog.open() == 1) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IPath filePath = dialog.getResult();
                if (filePath == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile file = workspace.getRoot().getFile(filePath);
                newInput = new FileEditorInput(file);
            }
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange(newInput);
                    this.syncDocumentProvider();
                    provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException ex) {
                    IStatus status = ex.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        VexPlugin.getDefault().log(4, ex.getLocalizedMessage(), ex);
                        String title = Messages.getString("VexEditor.saveAs.error.title");
                        String msg = MessageFormat.format(Messages.getString("VexEditor.saveAs.error.message"), ex.getLocalizedMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                        this.setClean();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                provider.changed(newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                    this.setClean();
                }
                throw throwable;
            }
            provider.changed(newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
                this.setClean();
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    private void syncDocumentProvider() {
        if (!this.loaded) {
            return;
        }
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        this.handleDocumentChange = false;
        org.eclipse.jface.text.IDocument jFaceDoc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        Object doc = this.internalModified ? jFaceDoc : new Document();
        try {
            provider.aboutToChange((Object)this.getEditorInput());
            if (this.positionOfCurrentNode != null) {
                jFaceDoc.removePosition((Position)this.positionOfCurrentNode);
            }
            this.positionOfCurrentNode = this.createDocumentWriter().write(this.document, doc, this.vexWidget.getCurrentNode());
            this.positionOfCurrentNode.setOffsetInNode(this.vexWidget.getCaretPosition().getOffset() - this.vexWidget.getCurrentNode().getStartPosition().getOffset());
            try {
                jFaceDoc.addPosition((Position)this.positionOfCurrentNode);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        finally {
            provider.changed((Object)this.getEditorInput());
            this.internalModified = false;
            this.handleDocumentChange = true;
        }
    }

    private DocumentWriter createDocumentWriter() {
        DocumentWriter result = new DocumentWriter();
        result.setWhitespacePolicy(this.vexWidget.getWhitespacePolicy());
        result.setIndent(this.preferences.getIndentationPattern());
        result.setWrapColumn(this.preferences.getLineWidth());
        return result;
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getEditorSite().getActionBars().getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    public DocumentType getDocumentType() {
        return this.doctype;
    }

    public Style getStyle() {
        return this.style;
    }

    public VexWidget getVexWidget() {
        return this.vexWidget;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.activationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    public boolean isEditorInputReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            return extension.isReadOnly((Object)this.getEditorInput());
        }
        return true;
    }

    private void setDirty() {
        this.internalModified = true;
        if (this.dirty) {
            return;
        }
        this.dirty = true;
        this.firePropertyChange(257);
        this.makeJFaceDocumentDirty();
    }

    private void makeJFaceDocumentDirty() {
        org.eclipse.jface.text.IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            try {
                this.handleDocumentChange = false;
                doc.replace(0, 1, doc.get(0, 1));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                this.handleDocumentChange = true;
            }
        }
        finally {
            this.handleDocumentChange = true;
        }
    }

    private void setClean() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isLoaded() && this.isDirty();
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.configurationRegistry.addConfigListener(this.configListener);
        if (this.configurationRegistry.isLoaded()) {
            this.setInputFromProvider();
        } else {
            this.showLabel(Messages.getString("VexEditor.loading"));
        }
    }

    public void removeVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.remove((Object)listener);
    }

    public void setFocus() {
        if (this.vexWidget != null) {
            this.vexWidget.setFocus();
            this.setStatus(this.getLocationPath());
        }
    }

    protected void setInput(IEditorInput input) {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null) {
            this.getDocumentProvider().getDocument((Object)oldInput).removeDocumentListener(this.jFaceDocumentListener);
            this.getDocumentProvider().disconnect((Object)oldInput);
        }
        super.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getName());
        this.updateDocumentProvider(input);
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            String msg = MessageFormat.format(Messages.getString("VexEditor.noProvider"), input.getClass());
            this.showLabel(msg);
            return;
        }
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        provider.getDocument((Object)input).addDocumentListener(this.jFaceDocumentListener);
    }

    protected void setInputFromProvider() {
        this.loaded = false;
        this.dirty = false;
        IDocumentProvider provider = this.getDocumentProvider();
        IValidator validator = null;
        try {
            IDocumentProviderExtension extension;
            IStatus status;
            VexDocumentContentModel documentContentModel;
            if (this.vexWidget != null) {
                this.vexEditorListeners.fireEvent("documentUnloaded", (EventObject)new VexEditorEvent(this));
            }
            if (this.document != null) {
                this.document.removeDocumentListener(this.documentListener);
                validator = this.document.getValidator();
            }
            if (validator != null) {
                documentContentModel = (VexDocumentContentModel)validator.getDocumentContentModel();
            } else {
                documentContentModel = new VexDocumentContentModel(this.getSite().getShell());
                validator = new WTPVEXValidator((DocumentContentModel)documentContentModel);
            }
            DocumentReader reader = new DocumentReader();
            reader.setDebugging(this.debugging);
            reader.setValidator(validator);
            reader.setStyleSheetProvider((IStyleSheetProvider)VexPlugin.getDefault().getPreferences());
            reader.setWhitespacePolicyFactory(CssWhitespacePolicy.FACTORY);
            org.eclipse.jface.text.IDocument jFaceDoc = provider.getDocument((Object)this.getEditorInput());
            if (provider instanceof IDocumentProviderExtension && (status = (extension = (IDocumentProviderExtension)this.getDocumentProvider()).getStatus((Object)this.getEditorInput())) != null && status.getSeverity() == 4) {
                this.showLabel(status.getMessage());
                return;
            }
            String encoding = provider instanceof IStorageDocumentProvider ? ((IStorageDocumentProvider)provider).getEncoding((Object)this.getEditorInput()) : "UTF-8";
            InputSource is = new InputSource(new DocumentInputReader(jFaceDoc));
            is.setEncoding(encoding);
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                is.setSystemId(file.getLocationURI().toString());
            } else if (input instanceof IStorageEditorInput) {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                is.setSystemId(storage.getFullPath().toString());
            } else if (input instanceof IURIEditorInput) {
                URI uri = ((IURIEditorInput)input).getURI();
                is.setSystemId(uri.toString());
            } else {
                String msg = MessageFormat.format(Messages.getString("VexEditor.unknownInputClass"), input.getClass());
                this.showLabel(msg);
                return;
            }
            if (this.positionOfCurrentNode != null) {
                this.positionOfCurrentNode.computePosition(jFaceDoc);
                reader.setCaretPosition(this.positionOfCurrentNode);
            }
            this.document = reader.read(is);
            if (this.document == null) {
                this.showLabel(MessageFormat.format(Messages.getString("VexEditor.noContent"), this.getEditorInput().getName()));
                return;
            }
            this.doctype = documentContentModel.getDocumentType();
            this.style = documentContentModel.getStyle();
            this.style.getStyleSheet().flushAllStyles(this.document);
            this.document.setValidator(validator);
            if (documentContentModel.shouldAssignInferredDocumentType()) {
                this.document.setPublicID(this.doctype.getPublicId());
                this.document.setSystemID(this.doctype.getSystemId());
                this.internalModified = true;
                this.syncDocumentProvider();
                this.setDirty();
            }
            this.showVexWidget();
            this.document.addDocumentListener(this.documentListener);
            this.vexWidget.setDebugging(this.debugging);
            this.vexWidget.setWhitespacePolicy(reader.getWhitespacePolicy());
            this.vexWidget.setDocument(this.document, this.style.getStyleSheet());
            this.vexWidget.setReadOnly(this.isEditorInputReadOnly());
            INode nodeAtCaret = reader.getNodeAtCaret();
            if (nodeAtCaret != null) {
                int offsetInNode = Math.min(nodeAtCaret.getStartOffset() + this.positionOfCurrentNode.getOffsetInNode(), nodeAtCaret.getEndOffset());
                this.vexWidget.moveTo(new ContentPosition(null, offsetInNode));
            }
            this.loaded = true;
            if (provider.canSaveDocument((Object)this.getEditorInput())) {
                this.dirty = true;
            }
            this.vexEditorListeners.fireEvent("documentLoaded", (EventObject)new VexEditorEvent(this));
        }
        catch (SAXParseException ex) {
            if (ex.getException() instanceof NoRegisteredDoctypeException) {
                NoRegisteredDoctypeException ex2 = (NoRegisteredDoctypeException)ex.getException();
                String msg = ex2.getPublicId() == null ? Messages.getString("VexEditor.noDoctype") : MessageFormat.format(Messages.getString("VexEditor.unknownDoctype"), ex2.getPublicId());
                this.showLabel(msg);
            } else if (ex.getException() instanceof NoStyleForDoctypeException) {
                String msg = MessageFormat.format(Messages.getString("VexEditor.noStyles"), this.doctype.getPublicId());
                this.showLabel(msg);
            } else {
                String file = ex.getSystemId();
                if (file == null) {
                    file = this.getEditorInput().getName();
                }
                String msg = MessageFormat.format(Messages.getString("VexEditor.parseError"), ex.getLineNumber(), file, ex.getLocalizedMessage());
                this.showLabel(msg);
                VexPlugin.getDefault().log(4, msg, ex);
            }
        }
        catch (NoRegisteredDoctypeException ex) {
            if (ex.isUserCanceled()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, true);
            } else {
                String msg = MessageFormat.format(Messages.getString("VexEditor.unexpectedError"), this.getEditorInput().getName());
                VexPlugin.getDefault().log(4, msg, ex);
                this.showLabel(msg, ex);
            }
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Messages.getString("VexEditor.unexpectedError"), this.getEditorInput().getName());
            VexPlugin.getDefault().log(4, msg, ex);
            this.showLabel(msg, ex);
        }
    }

    public void setStatus(String text) {
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(text);
    }

    public void setStyle(Style style) {
        this.style = style;
        if (this.vexWidget != null) {
            this.vexWidget.setStyleSheet(style.getStyleSheet());
            this.preferences.setPreferredStyleId(this.doctype, style.getUniqueId());
        }
        this.vexEditorListeners.fireEvent("styleChanged", (EventObject)new VexEditorEvent(this));
    }

    private void showLabel(String message, Exception ex) {
        if (this.loadingLabel == null) {
            if (this.vexWidget != null) {
                this.vexWidget.dispose();
                this.vexWidget = null;
            }
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.parentControl.setLayout((Layout)layout);
            this.loadingLabel = new Text(this.parentControl, 576);
            this.loadingLabel.setEditable(false);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            this.loadingLabel.setLayoutData((Object)gd);
        }
        StringWriter sw = new StringWriter();
        sw.append(message);
        if (ex != null) {
            sw.append("\n\n");
            ex.printStackTrace(new PrintWriter(sw));
        }
        this.loadingLabel.setText(sw.toString());
        this.parentControl.layout(true);
    }

    private void showLabel(String message) {
        this.showLabel(message, null);
    }

    private void showVexWidget() {
        if (this.vexWidget != null) {
            return;
        }
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parentControl.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget = new VexWidget(this.parentControl, 512);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget.setLayoutData((Object)gd);
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu("org.eclipse.vex.ui.popup", menuManager, (ISelectionProvider)this.vexWidget);
        this.vexWidget.setMenu(menuManager.createContextMenu((Control)this.vexWidget));
        this.setClean();
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext("org.eclipse.vex.ui.VexEditorContext");
        this.vexWidget.addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        this.parentControl.layout(true);
    }

    private String getLocationPath() {
        ArrayList<String> path = new ArrayList<String>();
        INode node = this.vexWidget.getCurrentNode();
        while (node != null) {
            path.add((String)node.accept(this.nodePathVisitor));
            node = node.getParent();
        }
        Collections.reverse(path);
        if (path.isEmpty()) {
            return "/";
        }
        StringBuilder pathString = new StringBuilder(path.size() * 15);
        for (String part : path) {
            if (part.isEmpty()) continue;
            pathString.append('/');
            pathString.append(part);
        }
        return pathString.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            return new DocumentOutlinePage(this);
        }
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof IElement) {
                        IStructuredSelection selection = (IStructuredSelection)VexEditor.this.vexWidget.getSelection();
                        boolean multipleElementsSelected = selection != null && selection.size() > 1;
                        IValidator validator = VexEditor.this.vexWidget.getDocument().getValidator();
                        return new ElementPropertySource((IElement)object, validator, multipleElementsSelected);
                    }
                    if (object instanceof IIncludeNode) {
                        IStructuredSelection selection = (IStructuredSelection)VexEditor.this.vexWidget.getSelection();
                        boolean multipleElementsSelected = selection != null && selection.size() > 1;
                        IValidator validator = VexEditor.this.vexWidget.getDocument().getValidator();
                        return new ElementPropertySource((IElement)((IIncludeNode)object).getReference(), validator, multipleElementsSelected);
                    }
                    if (object instanceof IDocument) {
                        return new DocumentPropertySource((IDocument)object);
                    }
                    return null;
                }
            });
            return page;
        }
        if (adapter == IFindReplaceTarget.class) {
            return new AbstractRegExFindReplaceTarget(){

                @Override
                protected int getSelectionStart() {
                    return VexEditor.this.getVexWidget().getSelectedRange().getStartOffset();
                }

                @Override
                protected int getSelectionEnd() {
                    return VexEditor.this.getVexWidget().getSelectedRange().getEndOffset();
                }

                @Override
                protected void setSelection(int start, int end) {
                    VexEditor.this.getVexWidget().moveTo(new ContentPosition(VexEditor.this.document, start));
                    VexEditor.this.getVexWidget().moveTo(new ContentPosition(VexEditor.this.document, end), true);
                }

                @Override
                protected CharSequence getDocument() {
                    return VexEditor.this.document.getContent();
                }

                @Override
                protected void inDocumentReplaceSelection(CharSequence text) {
                    VexWidget vexWidget = VexEditor.this.getVexWidget();
                    vexWidget.beginWork();
                    try {
                        vexWidget.deleteSelection();
                        vexWidget.insertText(text.toString());
                    }
                    finally {
                        vexWidget.endWork(true);
                    }
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private void handleEditorActivated() {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        boolean fileChange = this.checkDocumentState();
        if (fileChange && this.hasBeenActivated) {
            this.handleEditorInputChanged();
        } else if (this.externalModified) {
            this.setInputFromProvider();
        }
        this.externalModified = false;
    }

    private void handleEditorInputChanged() {
        IEditorInput input;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider.isDeleted((Object)(input = this.getEditorInput()))) {
            String title = Messages.getString("VexEditor.docDeleted.title");
            String message = MessageFormat.format(Messages.getString("VexEditor.docDeleted.message"), input.getName());
            String[] buttons = new String[]{Messages.getString("VexEditor.docDeleted.save"), Messages.getString("VexEditor.docDeleted.discard")};
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, message, 3, buttons, 0);
            if (dialog.open() == 0) {
                IProgressMonitor pm = this.getProgressMonitor();
                this.performSaveAs(pm);
                if (pm.isCanceled()) {
                    this.handleEditorInputChanged();
                }
            } else {
                this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            }
        } else {
            String title = Messages.getString("VexEditor.docChanged.title");
            String message = MessageFormat.format(Messages.getString("VexEditor.docChanged.message"), this.getEditorInput().getName());
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)title, (String)message)) {
                if (provider instanceof IDocumentProviderExtension) {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    try {
                        extension.synchronize((Object)input);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                this.setInputFromProvider();
            } else if (!this.isDirty()) {
                try {
                    org.eclipse.jface.text.IDocument document = provider.getDocument((Object)input);
                    if (document != null) {
                        document.replace(0, 0, "");
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private boolean checkDocumentState() {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return false;
        }
        IEditorInput input = this.getEditorInput();
        if (p instanceof IDocumentProviderExtension3) {
            IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)p;
            long stamp = p.getModificationStamp((Object)input);
            if (stamp != this.docModificationStamp) {
                this.docModificationStamp = stamp;
                if (!p3.isSynchronized((Object)input)) {
                    return true;
                }
            }
        } else {
            long stamp;
            if (this.docModificationStamp == -1L) {
                this.docModificationStamp = p.getSynchronizationStamp((Object)input);
            }
            if ((stamp = p.getModificationStamp((Object)input)) != this.docModificationStamp) {
                this.docModificationStamp = stamp;
                if (stamp != p.getSynchronizationStamp((Object)input)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.documentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
    }

    private void updateDocumentProvider(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener(this.elementStateListener);
        }
        this.setDocumentProvider(input);
        provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener(this.elementStateListener);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    protected void disposeDocumentProvider() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IEditorInput input = this.getEditorInput();
            if (input != null) {
                provider.getDocument((Object)input).removeDocumentListener(this.jFaceDocumentListener);
                provider.disconnect((Object)input);
            }
            if (this.elementStateListener != null) {
                provider.removeElementStateListener(this.elementStateListener);
                this.elementStateListener = null;
            }
        }
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (this.fActivePart == VexEditor.this || this.fActivePart != null && this.fActivePart.getAdapter(AbstractTextEditor.class) == VexEditor.this) {
                VexEditor.this.syncDocumentProvider();
            }
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void handleActivation() {
            if (!VexEditor.this.handleActivation) {
                return;
            }
            if (this.fActivePart == VexEditor.this || this.fActivePart != null && this.fActivePart.getAdapter(AbstractTextEditor.class) == VexEditor.this) {
                VexEditor.this.handleActivation = false;
                try {
                    VexEditor.this.handleEditorActivated();
                }
                finally {
                    VexEditor.this.handleActivation = true;
                    VexEditor.this.hasBeenActivated = true;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (VexEditor.this.handleActivation && window == VexEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == VexEditor.this.getEditorSite().getWorkbenchWindow()) {
                VexEditor.this.syncDocumentProvider();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class ElementStateListener
    implements IElementStateListener {
        private Display display;

        private ElementStateListener() {
        }

        public void elementDirtyStateChanged(Object element, final boolean isDirty) {
            if (element != null && element.equals(VexEditor.this.getEditorInput()) && VexEditor.this.dirty != isDirty) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        VexEditor.this.handleActivation = true;
                        if (isDirty) {
                            VexEditor.this.dirty = true;
                            VexEditor.this.firePropertyChange(257);
                        } else {
                            VexEditor.this.setClean();
                        }
                    }
                };
                this.execute(r);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementDeleted(Object element) {
            VexEditor.this.getSite().getPage().closeEditor((IEditorPart)VexEditor.this, false);
        }

        public void elementMoved(Object originalElement, final Object movedElement) {
            if (originalElement != null && originalElement.equals(VexEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (movedElement == null || movedElement instanceof IEditorInput) {
                            String previousContent;
                            IDocumentProvider provider = VexEditor.this.getDocumentProvider();
                            if (VexEditor.this.internalModified) {
                                VexEditor.this.syncDocumentProvider();
                                previousContent = provider.getDocument((Object)VexEditor.this.getEditorInput()).get();
                            } else {
                                previousContent = null;
                            }
                            VexEditor.this.setInput((IEditorInput)movedElement);
                            if (previousContent != null) {
                                VexEditor.this.getDocumentProvider().getDocument((Object)VexEditor.this.getEditorInput()).set(previousContent);
                            }
                        }
                    }
                };
                this.execute(r);
            }
        }

        private void execute(Runnable runnable) {
            if (Display.getCurrent() == null) {
                if (this.display == null) {
                    this.display = VexEditor.this.getSite().getShell().getDisplay();
                }
                this.display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private class JFaceDocumentListener
    implements org.eclipse.jface.text.IDocumentListener {
        private JFaceDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (VexEditor.this.handleDocumentChange) {
                VexEditor.this.externalModified = true;
                if (!VexEditor.this.dirty) {
                    VexEditor.this.dirty = true;
                    VexEditor.this.firePropertyChange(257);
                }
            }
        }
    }
}

