/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.dom.CopyOfElement;
import org.eclipse.vex.core.internal.layout.LayoutUtils;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitor;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public abstract class AbstractAddColumnHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final VexWidget widget = VexHandlerUtil.computeWidget(event);
        widget.doWork(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractAddColumnHandler.this.addColumn(widget);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return null;
    }

    private void addColumn(VexWidget widget) throws ExecutionException {
        final int indexToDup = VexHandlerUtil.getCurrentColumnIndex((IVexWidget)widget);
        if (indexToDup == -1) {
            return;
        }
        final ArrayList cellsToDup = new ArrayList();
        VexHandlerUtil.iterateTableCells((IVexWidget)widget, new TableCellCallbackAdapter(){

            @Override
            public void onCell(LayoutUtils.ElementOrRange row, LayoutUtils.ElementOrRange cell, int rowIndex, int cellIndex) {
                if (cellIndex == indexToDup && cell instanceof IElement) {
                    cellsToDup.add((IElement)cell);
                }
            }
        });
        for (IElement element : cellsToDup) {
            widget.moveTo(this.addBefore() ? element.getStartPosition() : element.getEndPosition().moveBy(1));
            widget.insertElement(element.getQualifiedName()).accept((INodeVisitor)new CopyOfElement(element));
        }
        IElement firstCell = (IElement)cellsToDup.get(0);
        ContentPosition position = new ContentPosition((INode)firstCell, firstCell.getStartOffset() + 1);
        widget.moveTo(position);
    }

    protected abstract boolean addBefore();
}

