/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.layout.LayoutUtils;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPositionRange;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public abstract class AbstractMoveColumnHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final VexWidget widget = VexHandlerUtil.computeWidget(event);
        final VexHandlerUtil.RowColumnInfo rcInfo = VexHandlerUtil.getRowColumnInfo((IVexWidget)widget);
        if (rcInfo == null || !this.movingPossible(rcInfo)) {
            return null;
        }
        widget.doWork(new Runnable(){

            @Override
            public void run() {
                ArrayList sourceCells = new ArrayList();
                ArrayList targetCells = new ArrayList();
                AbstractMoveColumnHandler.this.computeCells(widget, rcInfo, sourceCells, targetCells);
                AbstractMoveColumnHandler.this.swapCells(widget, sourceCells, targetCells);
            }
        }, true);
        return null;
    }

    protected abstract boolean moveRight();

    private void computeCells(VexWidget widget, final VexHandlerUtil.RowColumnInfo rcInfo, final List<Object> sourceCells, final List<Object> targetCells) {
        VexHandlerUtil.iterateTableCells((IVexWidget)widget, new TableCellCallbackAdapter(){
            private Object leftCell;

            @Override
            public void onCell(LayoutUtils.ElementOrRange row, LayoutUtils.ElementOrRange cell, int rowIndex, int cellIndex) {
                if (AbstractMoveColumnHandler.this.leftCell(cellIndex, rcInfo.cellIndex)) {
                    this.leftCell = cell;
                } else if (AbstractMoveColumnHandler.this.rightCell(cellIndex, rcInfo.cellIndex)) {
                    sourceCells.add(AbstractMoveColumnHandler.this.moveRight() ? cell : this.leftCell);
                    targetCells.add(AbstractMoveColumnHandler.this.moveRight() ? this.leftCell : cell);
                }
            }
        });
    }

    private void swapCells(final VexWidget widget, List<Object> sourceCells, List<Object> targetCells) {
        int i = sourceCells.size() - 1;
        while (i >= 0) {
            Object source = sourceCells.get(i);
            Object target = targetCells.get(i);
            final ContentPositionRange sourceRange = VexHandlerUtil.getOuterRange(source);
            ContentPositionRange targetRange = VexHandlerUtil.getOuterRange(target);
            widget.moveTo(this.moveRight() ? targetRange.getStartPosition() : targetRange.getEndPosition());
            widget.savePosition(new Runnable(){

                @Override
                public void run() {
                    widget.moveTo(sourceRange.getStartPosition());
                    widget.moveTo(sourceRange.getEndPosition(), true);
                    widget.cutSelection();
                }
            });
            widget.paste();
            --i;
        }
    }

    protected abstract boolean movingPossible(VexHandlerUtil.RowColumnInfo var1);

    private boolean leftCell(int currentIndex, int sourceIndex) {
        return this.moveRight() ? currentIndex == sourceIndex : currentIndex == sourceIndex - 1;
    }

    private boolean rightCell(int currentIndex, int sourceIndex) {
        return this.moveRight() ? currentIndex == sourceIndex + 1 : currentIndex == sourceIndex;
    }
}

