/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.NoSuchElementException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.IFilter;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.IAxis;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;

public abstract class AbstractNavigateTableCellHandler
extends AbstractVexWidgetHandler {
    @Override
    public void execute(VexWidget widget) throws ExecutionException {
        IElement tableRow;
        IAxis parentTableRows = widget.getCurrentElement().ancestors().matching(AbstractNavigateTableCellHandler.displayedAsTableRow(widget.getStyleSheet()));
        try {
            tableRow = (IElement)parentTableRows.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        ContentPosition position = widget.getCaretPosition();
        this.navigate(widget, tableRow, position);
    }

    protected abstract void navigate(VexWidget var1, IElement var2, ContentPosition var3);

    private static IFilter<INode> displayedAsTableRow(final StyleSheet stylesheet) {
        return new IFilter<INode>(){

            public boolean matches(INode node) {
                return stylesheet.getStyles(node).getDisplay().equals("table-row");
            }
        };
    }
}

