/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPositionRange;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public abstract class AbstractRemoveTableCellsHandler
extends AbstractVexWidgetHandler {
    @Override
    public void execute(final VexWidget widget) throws ExecutionException {
        widget.doWork(new Runnable(){

            @Override
            public void run() {
                VexHandlerUtil.RowColumnInfo rcInfo = VexHandlerUtil.getRowColumnInfo((IVexWidget)widget);
                if (rcInfo == null) {
                    return;
                }
                AbstractRemoveTableCellsHandler.this.deleteCells(widget, AbstractRemoveTableCellsHandler.this.collectCellsToDelete(widget, rcInfo));
            }
        });
    }

    protected abstract List<Object> collectCellsToDelete(VexWidget var1, VexHandlerUtil.RowColumnInfo var2);

    private void deleteCells(VexWidget widget, List<Object> cellsToDelete) {
        int i = cellsToDelete.size() - 1;
        while (i >= 0) {
            Object cell = cellsToDelete.get(i);
            ContentPositionRange range = VexHandlerUtil.getOuterRange(cell);
            widget.moveTo(range.getStartPosition());
            widget.moveTo(range.getEndPosition(), true);
            widget.deleteSelection();
            --i;
        }
    }
}

