/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.IFilter;
import org.eclipse.vex.core.internal.css.IWhitespacePolicy;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentRange;
import org.eclipse.vex.core.provisional.dom.IAxis;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.IParent;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;

public class MoveSelectionUpHandler
extends AbstractVexWidgetHandler {
    @Override
    public void execute(VexWidget widget) throws ExecutionException {
        ContentRange selectedRange = widget.getSelectedRange();
        IAxis parentsContainingSelection = widget.getCurrentElement().ancestors().matching(MoveSelectionUpHandler.containingRange(selectedRange));
        IWhitespacePolicy policy = widget.getWhitespacePolicy();
        for (IParent parent : parentsContainingSelection) {
            IAxis blockChildren = parent.children().matching(MoveSelectionUpHandler.displayedAsBlock(policy));
            if (!blockChildren.isEmpty()) break;
            widget.moveTo(parent.getStartPosition(), false);
            widget.moveTo(parent.getEndPosition(), true);
        }
    }

    private static IFilter<INode> containingRange(final ContentRange range) {
        return new IFilter<INode>(){

            public boolean matches(INode node) {
                return node.getRange().contains(range);
            }
        };
    }

    private static IFilter<INode> displayedAsBlock(final IWhitespacePolicy policy) {
        return new IFilter<INode>(){

            public boolean matches(INode node) {
                return policy.isBlock(node);
            }
        };
    }
}

