/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.NoSuchElementException;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.handlers.AbstractNavigateTableCellHandler;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public class NextTableCellHandler
extends AbstractNavigateTableCellHandler {
    @Override
    protected void navigate(VexWidget widget, IElement tableRow, ContentPosition position) {
        for (IElement cell : tableRow.childElements()) {
            if (!cell.getStartPosition().isAfter(position)) continue;
            widget.moveTo(cell.getStartPosition().moveBy(1));
            return;
        }
        for (IElement siblingRow : tableRow.getParentElement().childElements()) {
            if (!siblingRow.getStartPosition().isAfter(position)) continue;
            IElement firstCell = NextTableCellHandler.firstCellOf(siblingRow);
            if (firstCell != null) {
                widget.moveTo(firstCell.getStartPosition().moveBy(1));
            } else {
                System.out.println("TODO - dup row into new empty row");
            }
            return;
        }
        VexHandlerUtil.duplicateTableRow((IVexWidget)widget, tableRow, false);
    }

    private static IElement firstCellOf(IElement tableRow) {
        try {
            return (IElement)tableRow.childElements().first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }
}

