/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.NoSuchElementException;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.handlers.AbstractNavigateTableCellHandler;

public class PreviousTableCellHandler
extends AbstractNavigateTableCellHandler {
    @Override
    protected void navigate(VexWidget widget, IElement tableRow, ContentPosition position) {
        IElement lastCell;
        IElement siblingCell = null;
        for (IElement cell : tableRow.childElements()) {
            if (cell.getEndPosition().isAfterOrEquals(position)) break;
            siblingCell = cell;
        }
        if (siblingCell != null) {
            widget.moveTo(siblingCell.getStartPosition().moveBy(1));
            return;
        }
        IElement siblingRow = null;
        for (IElement row : tableRow.getParentElement().childElements()) {
            if (row.getEndPosition().isAfterOrEquals(position)) break;
            siblingRow = row;
        }
        if (siblingRow != null && (lastCell = PreviousTableCellHandler.lastCellOf(siblingRow)) != null) {
            widget.moveTo(lastCell.getStartPosition().moveBy(1));
        }
    }

    private static IElement lastCellOf(IElement tableRow) {
        try {
            return (IElement)tableRow.childElements().last();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }
}

