/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;
import org.eclipse.vex.ui.internal.swt.ContentAssist;

public class SplitBlockElementHandler
extends AbstractVexWidgetHandler {
    @Override
    public void execute(VexWidget widget) throws ExecutionException {
        if (widget.isReadOnly()) {
            return;
        }
        INode currentNode = widget.getCurrentNode();
        if (widget.canSplit()) {
            this.splitElement((IVexWidget)widget, currentNode);
        } else {
            ContentPosition targetPosition = currentNode.getEndPosition().moveBy(1);
            if (widget.getDocument().getRootElement().containsPosition(targetPosition)) {
                widget.moveTo(targetPosition);
                ContentAssist.openAddElementsContentAssist(widget);
            }
        }
    }

    protected void splitElement(final IVexWidget vexWidget, final INode node) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                boolean isPreformatted = vexWidget.getWhitespacePolicy().isPre(node);
                if (isPreformatted) {
                    vexWidget.insertText("\n");
                } else {
                    vexWidget.split();
                }
            }
        });
    }
}

