/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.NoSuchElementException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.IFilter;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.IAxis;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.IParent;
import org.eclipse.vex.ui.internal.handlers.AddRowBelowHandler;
import org.eclipse.vex.ui.internal.handlers.SplitBlockElementHandler;

public class SplitItemHandler
extends SplitBlockElementHandler {
    @Override
    public void execute(VexWidget widget) throws ExecutionException {
        IParent firstTableRowOrListItem;
        StyleSheet stylesheet = widget.getStyleSheet();
        IAxis parentTableRowOrListItems = widget.getCurrentElement().ancestors().matching(this.displayedAsTableRowOrListItem(stylesheet));
        try {
            firstTableRowOrListItem = (IParent)parentTableRowOrListItems.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        String displayStyle = stylesheet.getStyles((INode)firstTableRowOrListItem).getDisplay();
        if (displayStyle.equals("table-row")) {
            new AddRowBelowHandler().execute(widget);
        } else if (displayStyle.equals("list-item")) {
            this.splitElement((IVexWidget)widget, (INode)firstTableRowOrListItem);
        }
    }

    private final IFilter<INode> displayedAsTableRowOrListItem(final StyleSheet stylesheet) {
        return new IFilter<INode>(){

            public boolean matches(INode node) {
                String displayStyle = stylesheet.getStyles(node).getDisplay();
                if (displayStyle.equals("table-row")) {
                    return true;
                }
                return displayStyle.equals("list-item");
            }
        };
    }
}

