/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;

public class StyleMenu
extends ContributionItem {
    public void fill(Menu menu, int index) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        final VexEditor editor = VexHandlerUtil.computeVexEditor(window);
        if (editor == null) {
            return;
        }
        DocumentType doctype = editor.getDocumentType();
        Style[] styleArray = VexPlugin.getDefault().getConfigurationRegistry().getStyles(doctype);
        int n = styleArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Style style = styleArray[n2];
            MenuItem menuItem = new MenuItem(menu, 16, index);
            menuItem.setText(style.getName());
            menuItem.setSelection(style == editor.getStyle());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    editor.setStyle(style);
                }
            });
            ++n2;
        }
    }
}

