/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;

public class TextEditingHandlerFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private String id;

    public Object create() throws CoreException {
        if (PreviousColumn.class.getSimpleName().equals(this.id)) {
            return new PreviousColumn();
        }
        if (NextColumn.class.getSimpleName().equals(this.id)) {
            return new NextColumn();
        }
        if (LineUp.class.getSimpleName().equals(this.id)) {
            return new LineUp();
        }
        if (LineDown.class.getSimpleName().equals(this.id)) {
            return new LineDown();
        }
        if (PreviousWord.class.getSimpleName().equals(this.id)) {
            return new PreviousWord();
        }
        if (NextWord.class.getSimpleName().equals(this.id)) {
            return new NextWord();
        }
        if (LineStart.class.getSimpleName().equals(this.id)) {
            return new LineStart();
        }
        if (LineEnd.class.getSimpleName().equals(this.id)) {
            return new LineEnd();
        }
        if (PageUp.class.getSimpleName().equals(this.id)) {
            return new PageUp();
        }
        if (PageDown.class.getSimpleName().equals(this.id)) {
            return new PageDown();
        }
        if (TextStart.class.getSimpleName().equals(this.id)) {
            return new TextStart();
        }
        if (TextEnd.class.getSimpleName().equals(this.id)) {
            return new TextEnd();
        }
        if (SelectPreviousColumn.class.getSimpleName().equals(this.id)) {
            return new SelectPreviousColumn();
        }
        if (SelectNextColumn.class.getSimpleName().equals(this.id)) {
            return new SelectNextColumn();
        }
        if (SelectLineUp.class.getSimpleName().equals(this.id)) {
            return new SelectLineUp();
        }
        if (SelectLineDown.class.getSimpleName().equals(this.id)) {
            return new SelectLineDown();
        }
        if (SelectPreviousWord.class.getSimpleName().equals(this.id)) {
            return new SelectPreviousWord();
        }
        if (SelectNextWord.class.getSimpleName().equals(this.id)) {
            return new SelectNextWord();
        }
        if (SelectLineStart.class.getSimpleName().equals(this.id)) {
            return new SelectLineStart();
        }
        if (SelectLineEnd.class.getSimpleName().equals(this.id)) {
            return new SelectLineEnd();
        }
        if (SelectPageUp.class.getSimpleName().equals(this.id)) {
            return new SelectPageUp();
        }
        if (SelectPageDown.class.getSimpleName().equals(this.id)) {
            return new SelectPageDown();
        }
        if (SelectTextStart.class.getSimpleName().equals(this.id)) {
            return new SelectTextStart();
        }
        if (SelectTextEnd.class.getSimpleName().equals(this.id)) {
            return new SelectTextEnd();
        }
        if (DeletePrevious.class.getSimpleName().equals(this.id)) {
            return new DeletePrevious();
        }
        if (DeleteNext.class.getSimpleName().equals(this.id)) {
            return new DeleteNext();
        }
        if (DeletePreviousWord.class.getSimpleName().equals(this.id)) {
            return new DeletePreviousWord();
        }
        if (DeleteNextWord.class.getSimpleName().equals(this.id)) {
            return new DeleteNextWord();
        }
        if (DeleteLine.class.getSimpleName().equals(this.id)) {
            return new DeleteLine();
        }
        if (DeleteToBeginningOfLine.class.getSimpleName().equals(this.id)) {
            return new DeleteToBeginningOfLine();
        }
        if (DeleteToEndOfLine.class.getSimpleName().equals(this.id)) {
            return new DeleteToEndOfLine();
        }
        if (CutLine.class.getSimpleName().equals(this.id)) {
            return new CutLine();
        }
        if (CutLineToBeginning.class.getSimpleName().equals(this.id)) {
            return new CutLineToBeginning();
        }
        if (CutLineToEnd.class.getSimpleName().equals(this.id)) {
            return new CutLineToEnd();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.vex.ui", 0, "Unknown id in data argument for " + this.getClass(), null));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.id = (String)data;
            return;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.vex.ui", 0, "Data argument must be a String for " + this.getClass(), null));
    }

    private static void selectWholeLines(VexWidget widget) {
        if (!widget.hasSelection()) {
            widget.moveToLineStart(false);
            widget.moveToLineEnd(true);
            return;
        }
        ContentPosition start = widget.getSelectedPositionRange().getStartPosition();
        ContentPosition end = widget.getSelectedPositionRange().getEndPosition();
        widget.moveTo(end);
        widget.moveToLineEnd(false);
        end = widget.getCaretPosition();
        widget.moveTo(start);
        widget.moveToLineStart(false);
        widget.moveTo(end, true);
    }

    private static class CutLine
    extends AbstractVexWidgetHandler {
        private CutLine() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            TextEditingHandlerFactory.selectWholeLines(widget);
            widget.cutSelection();
        }
    }

    private static class CutLineToBeginning
    extends AbstractVexWidgetHandler {
        private CutLineToBeginning() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            int selectionLength = widget.getSelectedRange().length();
            if (selectionLength > 1) {
                widget.moveTo(widget.getSelectedPositionRange().getStartPosition());
            }
            widget.moveToLineStart(true);
            widget.cutSelection();
            if (selectionLength > 1) {
                widget.moveBy(selectionLength, true);
            }
        }
    }

    private static class CutLineToEnd
    extends AbstractVexWidgetHandler {
        private CutLineToEnd() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            if (widget.hasSelection()) {
                widget.moveTo(widget.getSelectedPositionRange().getStartPosition());
            }
            widget.moveToLineEnd(true);
            widget.cutSelection();
        }
    }

    private static class DeleteLine
    extends AbstractVexWidgetHandler {
        private DeleteLine() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            TextEditingHandlerFactory.selectWholeLines(widget);
            widget.deleteSelection();
        }
    }

    private static class DeleteNext
    extends AbstractVexWidgetHandler {
        private DeleteNext() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.deleteNextChar();
        }
    }

    private static class DeleteNextWord
    extends AbstractVexWidgetHandler {
        private DeleteNextWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextWord(true);
            widget.deleteSelection();
        }
    }

    private static class DeletePrevious
    extends AbstractVexWidgetHandler {
        private DeletePrevious() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.deletePreviousChar();
        }
    }

    private static class DeletePreviousWord
    extends AbstractVexWidgetHandler {
        private DeletePreviousWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousWord(true);
            widget.deleteSelection();
        }
    }

    private static class DeleteToBeginningOfLine
    extends AbstractVexWidgetHandler {
        private DeleteToBeginningOfLine() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            int selectionLength = widget.getSelectedRange().length();
            if (selectionLength > 1) {
                widget.moveTo(widget.getSelectedPositionRange().getStartPosition());
            }
            widget.moveToLineStart(true);
            widget.deleteSelection();
            if (selectionLength > 1) {
                widget.moveBy(selectionLength, true);
            }
        }
    }

    private static class DeleteToEndOfLine
    extends AbstractVexWidgetHandler {
        private DeleteToEndOfLine() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            if (widget.hasSelection()) {
                widget.moveTo(widget.getSelectedPositionRange().getStartPosition());
            }
            widget.moveToLineEnd(true);
            widget.deleteSelection();
        }
    }

    private static class LineDown
    extends AbstractVexWidgetHandler {
        private LineDown() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextLine(false);
        }
    }

    private static class LineEnd
    extends AbstractVexWidgetHandler {
        private LineEnd() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToLineEnd(false);
        }
    }

    private static class LineStart
    extends AbstractVexWidgetHandler {
        private LineStart() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToLineStart(false);
        }
    }

    private static class LineUp
    extends AbstractVexWidgetHandler {
        private LineUp() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousLine(false);
        }
    }

    private static class NextColumn
    extends AbstractVexWidgetHandler {
        private NextColumn() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveBy(1);
        }
    }

    private static class NextWord
    extends AbstractVexWidgetHandler {
        private NextWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextWord(false);
        }
    }

    private static class PageDown
    extends AbstractVexWidgetHandler {
        private PageDown() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextPage(false);
        }
    }

    private static class PageUp
    extends AbstractVexWidgetHandler {
        private PageUp() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousPage(false);
        }
    }

    private static class PreviousColumn
    extends AbstractVexWidgetHandler {
        private PreviousColumn() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveBy(-1);
        }
    }

    private static class PreviousWord
    extends AbstractVexWidgetHandler {
        private PreviousWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousWord(false);
        }
    }

    private static class SelectLineDown
    extends AbstractVexWidgetHandler {
        private SelectLineDown() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextLine(true);
        }
    }

    private static class SelectLineEnd
    extends AbstractVexWidgetHandler {
        private SelectLineEnd() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToLineEnd(true);
        }
    }

    private static class SelectLineStart
    extends AbstractVexWidgetHandler {
        private SelectLineStart() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToLineStart(true);
        }
    }

    private static class SelectLineUp
    extends AbstractVexWidgetHandler {
        private SelectLineUp() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousLine(true);
        }
    }

    private static class SelectNextColumn
    extends AbstractVexWidgetHandler {
        private SelectNextColumn() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveBy(1, true);
        }
    }

    private static class SelectNextWord
    extends AbstractVexWidgetHandler {
        private SelectNextWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextWord(true);
        }
    }

    private static class SelectPageDown
    extends AbstractVexWidgetHandler {
        private SelectPageDown() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToNextPage(true);
        }
    }

    private static class SelectPageUp
    extends AbstractVexWidgetHandler {
        private SelectPageUp() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousPage(true);
        }
    }

    private static class SelectPreviousColumn
    extends AbstractVexWidgetHandler {
        private SelectPreviousColumn() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveBy(-1, true);
        }
    }

    private static class SelectPreviousWord
    extends AbstractVexWidgetHandler {
        private SelectPreviousWord() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveToPreviousWord(true);
        }
    }

    private static class SelectTextEnd
    extends AbstractVexWidgetHandler {
        private SelectTextEnd() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveTo(widget.getDocument().getEndPosition().moveBy(-1), true);
        }
    }

    private static class SelectTextStart
    extends AbstractVexWidgetHandler {
        private SelectTextStart() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveTo(widget.getDocument().getStartPosition(), true);
        }
    }

    private static class TextEnd
    extends AbstractVexWidgetHandler {
        private TextEnd() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveTo(widget.getDocument().getEndPosition().moveBy(-1));
        }
    }

    private static class TextStart
    extends AbstractVexWidgetHandler {
        private TextStart() {
        }

        @Override
        public void execute(VexWidget widget) throws ExecutionException {
            widget.moveTo(widget.getDocument().getStartPosition());
        }
    }
}

