/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.layout.ElementOrPositionRangeCallback;
import org.eclipse.vex.core.internal.layout.ElementOrRangeCallback;
import org.eclipse.vex.core.internal.layout.LayoutUtils;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.BaseNodeVisitor;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.ContentPositionRange;
import org.eclipse.vex.core.provisional.dom.ContentRange;
import org.eclipse.vex.core.provisional.dom.IAttribute;
import org.eclipse.vex.core.provisional.dom.IComment;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitor;
import org.eclipse.vex.core.provisional.dom.IParent;
import org.eclipse.vex.core.provisional.dom.IProcessingInstruction;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.handlers.ITableCellCallback;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;

public final class VexHandlerUtil {
    public static VexWidget computeWidget(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        VexHandlerUtil.assertNotNull(activeEditor);
        VexWidget widget = null;
        if (activeEditor instanceof VexEditor) {
            widget = ((VexEditor)activeEditor).getVexWidget();
        }
        VexHandlerUtil.assertNotNull(widget);
        return widget;
    }

    public static VexWidget computeWidget(IWorkbenchWindow window) {
        VexEditor editor = VexHandlerUtil.computeVexEditor(window);
        if (editor == null) {
            return null;
        }
        return editor.getVexWidget();
    }

    public static VexEditor computeVexEditor(IWorkbenchWindow window) {
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof VexEditor) {
            return (VexEditor)activeEditor;
        }
        return null;
    }

    private static void assertNotNull(Object object) throws ExecutionException {
        if (object == null) {
            throw new ExecutionException("Can not compute VexWidget.");
        }
    }

    public static void duplicateTableRow(final IVexWidget vexWidget, IElement tableRow, boolean addAbove) {
        StyleSheet styleSheet = vexWidget.getStyleSheet();
        if (!styleSheet.getStyles((INode)tableRow).getDisplay().equals("table-row")) {
            return;
        }
        if (addAbove) {
            vexWidget.moveTo(tableRow.getStartPosition());
        } else {
            vexWidget.moveTo(tableRow.getEndPosition().moveBy(1));
        }
        IElement newRow = vexWidget.insertElement(tableRow.getQualifiedName());
        Iterator childIterator = tableRow.children().withoutText().iterator();
        while (childIterator.hasNext()) {
            ((INode)childIterator.next()).accept((INodeVisitor)new BaseNodeVisitor(){

                public void visit(IElement element) {
                    IElement newElement = vexWidget.insertElement(element.getQualifiedName());
                    for (IAttribute attr : element.getAttributes()) {
                        newElement.setAttribute(attr.getQualifiedName(), attr.getValue());
                    }
                    vexWidget.moveBy(1);
                }

                public void visit(IComment comment) {
                    vexWidget.insertComment();
                    vexWidget.insertText(comment.getText());
                    vexWidget.moveBy(1);
                }

                public void visit(IProcessingInstruction pi) {
                    vexWidget.insertProcessingInstruction(pi.getTarget());
                    vexWidget.insertText(pi.getText());
                    vexWidget.moveBy(1);
                }
            });
        }
        try {
            INode firstTextChild = newRow.childElements().first();
            vexWidget.moveTo(firstTextChild.getStartPosition());
        }
        catch (NoSuchElementException noSuchElementException) {
            vexWidget.moveTo(newRow.getStartPosition().moveBy(1));
        }
    }

    public static boolean elementOrRangeIsPartiallySelected(IVexWidget widget, Object elementOrRange) {
        ContentRange elementContentRange = VexHandlerUtil.getInnerRange(elementOrRange);
        ContentRange selectedRange = widget.getSelectedRange();
        return elementContentRange.intersects(selectedRange);
    }

    public static int getCurrentColumnIndex(IVexWidget vexWidget) {
        IElement row = VexHandlerUtil.getCurrentTableRow(vexWidget);
        if (row == null) {
            return -1;
        }
        final ContentPosition offset = vexWidget.getCaretPosition();
        final int[] column = new int[]{-1};
        LayoutUtils.iterateTableCells((StyleSheet)vexWidget.getStyleSheet(), (IParent)row, (ElementOrRangeCallback)new ElementOrRangeCallback(){
            private int i = 0;

            public void onElement(IElement child, String displayStyle) {
                if (offset.isAfter(child.getStartPosition()) && offset.isBeforeOrEquals(child.getEndPosition())) {
                    column[0] = this.i;
                }
                ++this.i;
            }

            public void onRange(IParent parent, int startOffset, int endOffset) {
                ++this.i;
            }
        });
        return column[0];
    }

    public static IElement getCurrentTableRow(IVexWidget vexWidget) {
        StyleSheet styleSheet = vexWidget.getStyleSheet();
        IElement element = vexWidget.getCurrentElement();
        while (element != null) {
            if (styleSheet.getStyles((INode)element).getDisplay().equals("table-row")) {
                return element;
            }
            element = element.getParentElement();
        }
        return null;
    }

    public static SelectedRows getSelectedTableRows(final IVexWidget vexWidget) {
        final SelectedRows selected = new SelectedRows();
        VexHandlerUtil.iterateTableCells(vexWidget, new TableCellCallbackAdapter(){

            @Override
            public void startRow(Object row, int rowIndex) {
                if (VexHandlerUtil.elementOrRangeIsPartiallySelected(vexWidget, row)) {
                    if (selected.rows == null) {
                        selected.rows = new ArrayList();
                    }
                    selected.rows.add(row);
                } else if (selected.rows == null) {
                    selected.rowBefore = row;
                } else if (selected.rowAfter == null) {
                    selected.rowAfter = row;
                }
            }
        });
        return selected;
    }

    public static void iterateTableCells(IVexWidget vexWidget, final ITableCellCallback callback) {
        final StyleSheet ss = vexWidget.getStyleSheet();
        VexHandlerUtil.iterateTableRows(vexWidget, new ElementOrPositionRangeCallback(){
            private final int[] rowIndex = new int[1];

            public void onElement(final IElement row, String displayStyle) {
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells((StyleSheet)ss, (IParent)row, (ElementOrPositionRangeCallback)new ElementOrPositionRangeCallback(){
                    private int cellIndex = 0;

                    public void onElement(IElement cell, String displayStyle) {
                        callback.onCell(new LayoutUtils.ElementOrRange(row), new LayoutUtils.ElementOrRange(cell), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    public void onRange(IParent parent, ContentPosition startPosition, ContentPosition endPosition) {
                        ContentPositionRange range = new ContentPositionRange(startPosition, endPosition);
                        callback.onCell(new LayoutUtils.ElementOrRange(row), new LayoutUtils.ElementOrRange(range), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }

            public void onRange(IParent parent, ContentPosition startPosition, ContentPosition endPosition) {
                final ContentPositionRange row = new ContentPositionRange(startPosition, endPosition);
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells((StyleSheet)ss, (IParent)parent, (ContentPosition)startPosition, (ContentPosition)endPosition, (ElementOrPositionRangeCallback)new ElementOrPositionRangeCallback(){
                    private int cellIndex = 0;

                    public void onElement(IElement cell, String displayStyle) {
                        callback.onCell(new LayoutUtils.ElementOrRange(row), new LayoutUtils.ElementOrRange(cell), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    public void onRange(IParent parent, ContentPosition startPosition, ContentPosition endPosition) {
                        ContentPositionRange range = new ContentPositionRange(startPosition, endPosition);
                        callback.onCell(new LayoutUtils.ElementOrRange(row), new LayoutUtils.ElementOrRange(range), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }
        });
    }

    public static RowColumnInfo getRowColumnInfo(IVexWidget vexWidget) {
        final boolean[] found = new boolean[1];
        final RowColumnInfo[] rcInfo = new RowColumnInfo[]{new RowColumnInfo()};
        final ContentPosition position = vexWidget.getCaretPosition();
        rcInfo[0].cellIndex = -1;
        rcInfo[0].rowIndex = -1;
        VexHandlerUtil.iterateTableCells(vexWidget, new ITableCellCallback(){
            private int rowColumnCount;

            @Override
            public void startRow(Object row, int rowIndex) {
                this.rowColumnCount = 0;
            }

            @Override
            public void onCell(LayoutUtils.ElementOrRange row, LayoutUtils.ElementOrRange cell, int rowIndex, int cellIndex) {
                found[0] = true;
                if (row.contains(position)) {
                    rcInfo[0].row = row;
                    rcInfo[0].rowIndex = rowIndex;
                    ++rcInfo[0].columnCount;
                    if (cell.contains(position)) {
                        rcInfo[0].cell = cell;
                        rcInfo[0].cellIndex = cellIndex;
                    }
                }
                ++this.rowColumnCount;
            }

            @Override
            public void endRow(Object row, int rowIndex) {
                ++rcInfo[0].rowCount;
                rcInfo[0].maxColumnCount = Math.max(rcInfo[0].maxColumnCount, this.rowColumnCount);
            }
        });
        if (found[0]) {
            return rcInfo[0];
        }
        return null;
    }

    public static void iterateTableRows(IVexWidget vexWidget, ElementOrPositionRangeCallback callback) {
        StyleSheet ss = vexWidget.getStyleSheet();
        IDocument doc = vexWidget.getDocument();
        final ContentPosition position = vexWidget.getCaretPosition();
        IElement table = doc.getElementForInsertionAt(position.getOffset());
        while (table != null && !LayoutUtils.isTableChild((StyleSheet)ss, (IElement)table)) {
            table = table.getParentElement();
        }
        while (table != null && LayoutUtils.isTableChild((StyleSheet)ss, (IElement)table)) {
            table = table.getParentElement();
        }
        if (table == null || table.getParentElement() == null) {
            return;
        }
        final ArrayList tableChildren = new ArrayList();
        final boolean[] found = new boolean[1];
        LayoutUtils.iterateChildrenByDisplayStyle((StyleSheet)ss, (Set)LayoutUtils.TABLE_CHILD_STYLES, (IElement)table, (ElementOrRangeCallback)new ElementOrRangeCallback(){

            public void onElement(IElement child, String displayStyle) {
                if (position.isAfterOrEquals(child.getStartPosition()) && position.isBeforeOrEquals(child.getEndPosition())) {
                    found[0] = true;
                }
                tableChildren.add(child);
            }

            public void onRange(IParent parent, int startOffset, int endOffset) {
                if (!found[0]) {
                    tableChildren.clear();
                }
            }
        });
        if (!found[0]) {
            return;
        }
        ContentPosition startOffset = ((IElement)tableChildren.get(0)).getStartPosition();
        ContentPosition endOffset = ((IElement)tableChildren.get(tableChildren.size() - 1)).getEndPosition().moveBy(1);
        LayoutUtils.iterateTableRows((StyleSheet)ss, (IParent)table, (ContentPosition)startOffset, (ContentPosition)endOffset, (ElementOrPositionRangeCallback)callback);
    }

    public static ContentRange getInnerRange(Object elementOrRange) {
        if (elementOrRange instanceof IElement) {
            IElement element = (IElement)elementOrRange;
            return new ContentRange(element.getStartOffset() + 1, element.getEndOffset());
        }
        return (ContentRange)elementOrRange;
    }

    public static ContentPositionRange getOuterRange(Object elementOrRange) {
        if (elementOrRange instanceof IElement) {
            IElement element = (IElement)elementOrRange;
            return new ContentPositionRange(element.getStartPosition(), element.getEndPosition().moveBy(1));
        }
        return (ContentPositionRange)elementOrRange;
    }

    public static class RowColumnInfo {
        public Object row;
        public Object cell;
        public int rowIndex;
        public int cellIndex;
        public int rowCount;
        public int columnCount;
        public int maxColumnCount;
    }

    public static class SelectedRows {
        private List<Object> rows;
        private Object rowBefore;
        private Object rowAfter;

        private SelectedRows() {
        }

        public List<Object> getRows() {
            return this.rows;
        }

        public Object getRowBefore() {
            return this.rowBefore;
        }

        public Object getRowAfter() {
            return this.rowAfter;
        }
    }
}

