/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.namespace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.namespace.EditableNamespaceDefinition;

public class EditNamespacesController {
    private final IVexWidget widget;
    private final IElement element;
    private String defaultNamespaceURI;
    private final List<EditableNamespaceDefinition> namespaceDefinitions;

    public EditNamespacesController(IVexWidget widget) {
        this.widget = widget;
        this.element = widget.getCurrentElement();
        Assert.isNotNull((Object)this.element, (String)"There is no current element available. Namespaces can only be edited in elements.");
        this.defaultNamespaceURI = EditNamespacesController.getDefaultNamespaceURI(this.element);
        this.namespaceDefinitions = EditNamespacesController.getNamespaceDefinitions(this.element);
    }

    private static String getDefaultNamespaceURI(IElement element) {
        String result = element.getDeclaredDefaultNamespaceURI();
        if (result == null) {
            return "";
        }
        return result;
    }

    private static List<EditableNamespaceDefinition> getNamespaceDefinitions(IElement element) {
        ArrayList<EditableNamespaceDefinition> result = new ArrayList<EditableNamespaceDefinition>();
        for (String prefix : element.getDeclaredNamespacePrefixes()) {
            result.add(new EditableNamespaceDefinition(prefix, element.getNamespaceURI(prefix)));
        }
        return result;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void setDefaultNamespaceURI(String defaultNamespaceURI) {
        this.defaultNamespaceURI = defaultNamespaceURI;
    }

    public List<EditableNamespaceDefinition> getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public EditableNamespaceDefinition addNamespaceDefinition() {
        EditableNamespaceDefinition result = new EditableNamespaceDefinition();
        this.namespaceDefinitions.add(result);
        return result;
    }

    public void removeNamespaceDefinition(EditableNamespaceDefinition namespaceDefinition) {
        this.namespaceDefinitions.remove(namespaceDefinition);
    }

    public void applyToElement() {
        if (this.defaultNamespaceURI == null || "".equals(this.defaultNamespaceURI)) {
            this.widget.removeDefaultNamespace();
        } else {
            this.widget.declareDefaultNamespace(this.defaultNamespaceURI);
        }
        HashSet<String> declaredPrefixes = new HashSet<String>();
        for (EditableNamespaceDefinition definition : this.namespaceDefinitions) {
            this.widget.declareNamespace(definition.getPrefix(), definition.getUri());
            declaredPrefixes.add(definition.getPrefix());
        }
        for (String prefix : this.element.getDeclaredNamespacePrefixes()) {
            if (declaredPrefixes.contains(prefix)) continue;
            this.widget.removeNamespace(prefix);
        }
    }
}

