/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionBars;
import org.eclipse.vex.core.XML;
import org.eclipse.vex.core.internal.css.IWhitespacePolicy;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.provisional.dom.BaseNodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IAttribute;
import org.eclipse.vex.core.provisional.dom.IComment;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.IIncludeNode;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IParent;
import org.eclipse.vex.core.provisional.dom.IProcessingInstruction;
import org.eclipse.vex.core.provisional.dom.IText;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.PluginImages;
import org.eclipse.vex.ui.internal.editor.EditorEventAdapter;
import org.eclipse.vex.ui.internal.editor.IVexEditorListener;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.editor.VexEditorEvent;
import org.eclipse.vex.ui.internal.outline.DocumentOutlinePage;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;
import org.eclipse.vex.ui.internal.outline.IToolBarContributor;
import org.eclipse.vex.ui.internal.outline.ToolBarToggleAction;

public class DefaultOutlineProvider
implements IOutlineProvider,
IToolBarContributor {
    public static final String SHOW_ELEMENT_CONTENT = "showElementContent";
    private ITreeContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;
    private boolean showElementContent = false;
    private static final int MAX_CONTENT_LENGTH = 30;

    @Override
    public void init(VexEditor editor) {
        this.contentProvider = new OutlineContentProvider();
        this.labelProvider = new OutlineLabelProvider(editor);
        this.initStates();
    }

    public void init(StyleSheet styleSheet, IWhitespacePolicy whitespacePolicy) {
        this.contentProvider = new OutlineContentProvider();
        this.labelProvider = new OutlineLabelProvider(styleSheet, whitespacePolicy);
        this.initStates();
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IElement getOutlineElement(IElement child) {
        return child;
    }

    @Override
    public void setState(String commandId, boolean state) {
        if (commandId.equals(SHOW_ELEMENT_CONTENT)) {
            this.showElementContent = state;
        }
    }

    @Override
    public void registerToolBarActions(DocumentOutlinePage page, IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)new ToolBarToggleAction(page, SHOW_ELEMENT_CONTENT, PluginImages.DESC_SHOW_ELEMENT_CONTENT));
    }

    public boolean isStateSupported(String commandId) {
        return commandId.equals(SHOW_ELEMENT_CONTENT);
    }

    public StyledString getOutlineLabel(INode element) {
        return ((OutlineLabelProvider)this.labelProvider).getElementLabel(element);
    }

    public Image getOutlineImage(IElement element) {
        return ((OutlineLabelProvider)this.labelProvider).getElementImage((INode)element);
    }

    private void initStates() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        if (preferences != null) {
            this.showElementContent = preferences.getBoolean(SHOW_ELEMENT_CONTENT, true);
        }
    }

    private class OutlineContentProvider
    implements ITreeContentProvider {
        private OutlineContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getOutlineChildren((INode)parentElement);
        }

        public Object getParent(Object node) {
            IParent parent = ((INode)node).getParent();
            if (parent == null) {
                return null;
            }
            return parent;
        }

        public boolean hasChildren(Object node) {
            return this.getOutlineChildren((INode)node).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            IDocument document = (IDocument)inputElement;
            IElement root = document.getRootElement();
            if (root.hasChildren()) {
                return document.getRootElement().children().asList().toArray();
            }
            return new Object[]{root};
        }

        private INode[] getOutlineChildren(INode node) {
            if (!(node instanceof IParent)) {
                return new INode[0];
            }
            ArrayList<INode> children = new ArrayList<INode>();
            for (INode child : ((IParent)node).children().withoutText()) {
                children.add(child);
            }
            return children.toArray(new INode[children.size()]);
        }
    }

    private class OutlineLabelProvider
    extends StyledCellLabelProvider {
        private static final String EMPTY_STRING = "";
        private VexEditor editor = null;
        private IVexEditorListener listener = null;
        private StyleSheet styleSheet;
        private IWhitespacePolicy whitespacePolicy;
        private final INodeVisitorWithResult<Image> elementImageVisitor = new BaseNodeVisitorWithResult<Image>(PluginImages.get("org.eclipse.vex.ui.img.xml_unknown")){

            public Image visit(IElement element) {
                if (OutlineLabelProvider.this.whitespacePolicy.isBlock((INode)element)) {
                    return PluginImages.get("org.eclipse.vex.ui.img.xml_block_element");
                }
                return PluginImages.get("org.eclipse.vex.ui.img.xml_inline_element");
            }

            public Image visit(IComment comment) {
                return PluginImages.get("org.eclipse.vex.ui.img.xml_comment");
            }

            public Image visit(IProcessingInstruction pi) {
                return PluginImages.get("org.eclipse.vex.ui.img.xml_proc_instr");
            }

            public Image visit(IIncludeNode include) {
                return this.visit((IElement)include.getReference());
            }
        };
        private final INodeVisitorWithResult<String> elementLabelVisitor = new BaseNodeVisitorWithResult<String>(""){

            public String visit(IElement element) {
                return element.getLocalName();
            }

            public String visit(IComment comment) {
                return Messages.getString("VexEditor.Path.Comment");
            }

            public String visit(IProcessingInstruction pi) {
                return pi.getTarget();
            }

            public String visit(IIncludeNode include) {
                return include.getReference().getPrefixedName();
            }
        };

        public OutlineLabelProvider(VexEditor editor) {
            this(editor.getStyle().getStyleSheet(), editor.getVexWidget().getWhitespacePolicy());
            this.editor = editor;
            this.listener = new EditorEventAdapter(){

                @Override
                public void styleChanged(VexEditorEvent event) {
                    OutlineLabelProvider.this.styleSheet = event.getVexEditor().getStyle().getStyleSheet();
                    OutlineLabelProvider.this.whitespacePolicy = event.getVexEditor().getVexWidget().getWhitespacePolicy();
                }
            };
            editor.addVexEditorListener(this.listener);
        }

        public OutlineLabelProvider(StyleSheet styleSheet, IWhitespacePolicy whitespacePolicy) {
            this.styleSheet = styleSheet;
            this.whitespacePolicy = whitespacePolicy;
        }

        public void update(ViewerCell cell) {
            INode node = (INode)cell.getElement();
            StyledString label = this.getElementLabel(node);
            cell.setText(label.getString());
            cell.setStyleRanges(label.getStyleRanges());
            cell.setImage(this.getElementImage(node));
            super.update(cell);
        }

        public void dispose() {
            super.dispose();
            if (this.editor != null) {
                this.editor.removeVexEditorListener(this.listener);
            }
        }

        public Image getElementImage(INode node) {
            return (Image)node.accept(this.elementImageVisitor);
        }

        public StyledString getElementLabel(INode node) {
            String rawLabel = (String)node.accept(this.elementLabelVisitor);
            if (!DefaultOutlineProvider.this.showElementContent) {
                return new StyledString(rawLabel);
            }
            StyledString label = new StyledString(rawLabel);
            String content = null;
            Object outlineElement = this.styleSheet.getStyles(node).getOutlineContent();
            if (outlineElement != null) {
                if (outlineElement instanceof IAttribute) {
                    content = ((IAttribute)outlineElement).getValue();
                } else if (outlineElement instanceof IParent) {
                    content = EMPTY_STRING;
                    Iterator childIter = ((IParent)outlineElement).children().iterator();
                    while (content.length() < 30 && childIter.hasNext()) {
                        content = String.valueOf(content) + (String)((INode)childIter.next()).accept((INodeVisitorWithResult)new BaseNodeVisitorWithResult<String>(EMPTY_STRING){

                            public String visit(IElement element) {
                                return element.getText();
                            }

                            public String visit(IText text) {
                                return text.getText();
                            }
                        });
                    }
                    content = XML.compressWhitespace((String)content, (boolean)false, (boolean)false, (boolean)false);
                } else if (outlineElement instanceof IProcessingInstruction) {
                    content = ((IProcessingInstruction)outlineElement).getText();
                    content = XML.compressWhitespace((String)content, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            if (content != null && content.length() > 0) {
                if (content.length() > 27) {
                    content = String.valueOf(content.substring(0, Math.min(30, content.length()))) + "...";
                }
                label.append(" " + content, StyledString.DECORATIONS_STYLER);
            }
            return label;
        }
    }
}

