/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.AttributeChangeEvent;
import org.eclipse.vex.core.provisional.dom.ContentChangeEvent;
import org.eclipse.vex.core.provisional.dom.IAttribute;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IDocumentListener;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.IParent;
import org.eclipse.vex.core.provisional.dom.NamespaceDeclarationChangeEvent;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.EditorEventAdapter;
import org.eclipse.vex.ui.internal.editor.IVexEditorListener;
import org.eclipse.vex.ui.internal.editor.SelectionProvider;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.editor.VexEditorEvent;
import org.eclipse.vex.ui.internal.outline.DefaultOutlineProvider;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;
import org.eclipse.vex.ui.internal.outline.IToolBarContributor;
import org.eclipse.vex.ui.internal.outline.OutlineFilterActionGroup;
import org.osgi.framework.Bundle;

public class DocumentOutlinePage
extends Page
implements IContentOutlinePage {
    private Composite composite;
    private Label label;
    private TreeViewer treeViewer;
    private OutlineFilterActionGroup filterActionGroup;
    private final VexEditor vexEditor;
    private IOutlineProvider outlineProvider;
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){
        private Object[] lastExpandedElements = null;
        private INode selectedTreeNode;

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() instanceof VexWidget) {
                VexWidget vexWidget = (VexWidget)event.getSource();
                if (vexWidget.isFocusControl() && DocumentOutlinePage.this.getTreeViewer() != null) {
                    INode element = vexWidget.getCurrentNode();
                    if (element == null || element.equals(this.selectedTreeNode)) {
                        return;
                    }
                    if (element.getDocument().getRootElement() == element) {
                        return;
                    }
                    this.selectedTreeNode = element;
                    while (this.selectedTreeNode != null && DocumentOutlinePage.this.filterActionGroup.isElementFiltered(this.selectedTreeNode)) {
                        this.selectedTreeNode = this.selectedTreeNode.getParent();
                    }
                    if (this.selectedTreeNode != null) {
                        DocumentOutlinePage.this.getTreeViewer().getControl().setRedraw(false);
                        BusyIndicator.showWhile((Display)DocumentOutlinePage.this.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (lastExpandedElements != null) {
                                    DocumentOutlinePage.this.getTreeViewer().setExpandedElements(lastExpandedElements);
                                    lastExpandedElements = null;
                                }
                                if (!DocumentOutlinePage.this.getTreeViewer().getExpandedState((Object)selectedTreeNode.getParent())) {
                                    lastExpandedElements = DocumentOutlinePage.this.getTreeViewer().getExpandedElements();
                                }
                                DocumentOutlinePage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)selectedTreeNode));
                            }
                        });
                        DocumentOutlinePage.this.getTreeViewer().getControl().setRedraw(true);
                    } else {
                        DocumentOutlinePage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection());
                        this.selectedTreeNode = null;
                    }
                }
            } else {
                TreeItem[] selected;
                TreeViewer treeViewer = (TreeViewer)event.getSource();
                if (treeViewer.getTree().isFocusControl() && (selected = treeViewer.getTree().getSelection()).length > 0) {
                    INode node;
                    this.lastExpandedElements = null;
                    this.selectedTreeNode = node = (INode)selected[0].getData();
                    VexWidget vexWidget = DocumentOutlinePage.this.vexEditor.getVexWidget();
                    vexWidget.moveTo(node.getEndPosition());
                    vexWidget.moveTo(node.getStartPosition().moveBy(1), true);
                }
            }
        }
    };
    private final IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            TreeItem[] selected;
            if (DocumentOutlinePage.this.treeViewer.getTree().isFocusControl() && (selected = DocumentOutlinePage.this.treeViewer.getTree().getSelection()).length > 0) {
                INode node = (INode)selected[0].getData();
                VexWidget vexWidget = DocumentOutlinePage.this.vexEditor.getVexWidget();
                vexWidget.moveTo(node.getStartPosition().moveBy(1));
                vexWidget.setFocus();
            }
        }
    };
    private final IVexEditorListener vexEditorListener = new EditorEventAdapter(){

        @Override
        public void documentLoaded(VexEditorEvent event) {
            DocumentOutlinePage.this.showTreeViewer();
        }

        @Override
        public void documentUnloaded(VexEditorEvent event) {
            DocumentOutlinePage.this.showLabel(Messages.getString("DocumentOutlinePage.reloading"));
        }

        @Override
        public void styleChanged(VexEditorEvent event) {
            DocumentOutlinePage.this.filterActionGroup.setStyleSheet(event.getVexEditor().getStyle().getStyleSheet());
        }
    };
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void attributeChanged(AttributeChangeEvent event) {
            IElement parent = (IElement)event.getParent();
            IAttribute attr = parent.getAttribute(event.getAttributeName());
            if (DocumentOutlinePage.this.vexEditor.getStyle().getStyleSheet().getStyles((INode)parent).getOutlineContent() == attr) {
                DocumentOutlinePage.this.getTreeViewer().refresh((Object)DocumentOutlinePage.this.outlineProvider.getOutlineElement(parent));
            }
        }

        public void namespaceChanged(NamespaceDeclarationChangeEvent event) {
        }

        public void beforeContentDeleted(ContentChangeEvent event) {
        }

        public void beforeContentInserted(ContentChangeEvent event) {
        }

        public void contentDeleted(ContentChangeEvent event) {
            IParent outlineElement = event.getParent();
            this.refreshOutlineElement(outlineElement);
        }

        public void contentInserted(ContentChangeEvent event) {
            IParent outlineElement = event.getParent();
            this.refreshOutlineElement(outlineElement);
        }

        private void refreshOutlineElement(IParent outlineElement) {
            if (outlineElement.getDocument().getRootElement().equals(outlineElement)) {
                DocumentOutlinePage.this.getTreeViewer().refresh();
            } else if (outlineElement instanceof IElement) {
                IElement parent = ((IElement)outlineElement).getParentElement();
                if (parent != null && DocumentOutlinePage.this.vexEditor.getStyle().getStyleSheet().getStyles((INode)parent).getOutlineContent() == outlineElement) {
                    DocumentOutlinePage.this.getTreeViewer().refresh((Object)DocumentOutlinePage.this.outlineProvider.getOutlineElement(parent));
                } else {
                    DocumentOutlinePage.this.getTreeViewer().refresh((Object)DocumentOutlinePage.this.outlineProvider.getOutlineElement((IElement)outlineElement));
                }
            }
        }
    };

    public DocumentOutlinePage(VexEditor vexEditor) {
        this.vexEditor = vexEditor;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.vexEditor.addVexEditorListener(this.vexEditorListener);
        this.vexEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
        this.initToolbarActions();
        if (this.vexEditor.isLoaded()) {
            this.showTreeViewer();
        } else {
            this.showLabel(Messages.getString("DocumentOutlinePage.loading"));
        }
    }

    public void dispose() {
        this.vexEditor.removeVexEditorListener(this.vexEditorListener);
        this.vexEditor.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
        if (this.filterActionGroup != null) {
            this.filterActionGroup.dispose();
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    public void setViewState(String stateId, boolean newValue) {
        if (this.outlineProvider instanceof IToolBarContributor) {
            ((IToolBarContributor)((Object)this.outlineProvider)).setState(stateId, newValue);
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    DocumentOutlinePage.this.treeViewer.refresh();
                }
            });
            this.treeViewer.getControl().setRedraw(true);
        }
    }

    private void showLabel(String message) {
        if (this.treeViewer != null) {
            this.treeViewer.removeSelectionChangedListener(this.selectionListener);
            this.treeViewer.getTree().dispose();
            this.getSite().getActionBars().getToolBarManager().removeAll();
            this.treeViewer = null;
        }
        if (this.label == null) {
            this.label = new Label(this.composite, 0);
            this.label.setText(message);
            this.composite.layout(true);
        }
        this.label.setText(message);
    }

    private void showTreeViewer() {
        if (this.treeViewer != null) {
            return;
        }
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        this.treeViewer = new TreeViewer(this.composite, 0);
        this.composite.layout();
        DocumentType doctype = this.vexEditor.getDocumentType();
        if (doctype == null) {
            return;
        }
        this.filterActionGroup.fillActionBars(this.getSite().getActionBars());
        String ns = doctype.getConfig().getUniqueIdentifer();
        Bundle bundle = Platform.getBundle((String)ns);
        String providerClassName = doctype.getOutlineProvider();
        if (bundle != null && providerClassName != null) {
            try {
                Class clazz = bundle.loadClass(providerClassName);
                this.outlineProvider = (IOutlineProvider)clazz.newInstance();
            }
            catch (Exception ex) {
                String message = Messages.getString("DocumentOutlinePage.loadingError");
                VexPlugin.getDefault().log(2, MessageFormat.format(message, providerClassName, ns, ex));
            }
        }
        if (this.outlineProvider == null) {
            this.outlineProvider = new DefaultOutlineProvider();
        }
        if (this.outlineProvider instanceof IToolBarContributor) {
            ((IToolBarContributor)((Object)this.outlineProvider)).registerToolBarActions(this, this.getSite().getActionBars());
        }
        this.outlineProvider.init(this.vexEditor);
        this.treeViewer.setContentProvider((IContentProvider)this.outlineProvider.getContentProvider());
        this.treeViewer.setLabelProvider(this.outlineProvider.getLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.filterActionGroup.setViewer((StructuredViewer)this.treeViewer);
        this.treeViewer.setUseHashlookup(true);
        IDocument document = this.vexEditor.getVexWidget().getDocument();
        this.treeViewer.setInput((Object)document);
        document.addDocumentListener(this.documentListener);
        this.treeViewer.addSelectionChangedListener(this.selectionListener);
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
    }

    private void initToolbarActions() {
        Style style = this.vexEditor.getStyle();
        this.filterActionGroup = style != null ? new OutlineFilterActionGroup(style.getStyleSheet()) : new OutlineFilterActionGroup(StyleSheet.NULL);
    }
}

