/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.provisional.dom.BaseNodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IComment;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.IIncludeNode;
import org.eclipse.vex.core.provisional.dom.INode;
import org.eclipse.vex.core.provisional.dom.INodeVisitorWithResult;
import org.eclipse.vex.core.provisional.dom.IProcessingInstruction;

public class OutlineFilter
extends ViewerFilter {
    public static final int FILTER_ID_INCLUDE_INLINE_ELEMENTS = 1;
    public static final int FILTER_ID_INCLUDE_COMMENTS = 2;
    public static final int FILTER_ID_INCLUDE_PROC_INSTR = 4;
    private int activeFilters = 0;
    private StyleSheet styleSheet;
    private final INodeVisitorWithResult<Boolean> filterVisitor = new BaseNodeVisitorWithResult<Boolean>(Boolean.valueOf(false)){

        public Boolean visit(IElement element) {
            IElement domElement = element;
            if (!OutlineFilter.this.hasFilter(1) && OutlineFilter.this.styleSheet.getStyles((INode)domElement).getDisplay().equals("inline")) {
                return false;
            }
            return true;
        }

        public Boolean visit(IComment comment) {
            return OutlineFilter.this.hasFilter(2);
        }

        public Boolean visit(IProcessingInstruction pi) {
            return OutlineFilter.this.hasFilter(4);
        }

        public Boolean visit(IIncludeNode include) {
            if (!OutlineFilter.this.hasFilter(1) && OutlineFilter.this.styleSheet.getStyles((INode)include.getReference()).getDisplay().equals("inline")) {
                return false;
            }
            return true;
        }
    };

    public OutlineFilter(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof INode)) {
            return true;
        }
        return (Boolean)((INode)element).accept(this.filterVisitor);
    }

    public final void addFilter(int filterId) {
        this.activeFilters |= filterId;
    }

    public final void removeFilter(int filterId) {
        this.activeFilters &= 0xFFFFFFFF ^ filterId;
    }

    public final boolean hasFilter(int filter) {
        return (this.activeFilters & filter) != 0;
    }
}

