/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.outline.OutlineFilterActionGroup;

public class OutlineFilterAction
extends Action {
    private final OutlineFilterActionGroup actionGroup;
    private final int filterId;
    private final String messageKey;

    public OutlineFilterAction(OutlineFilterActionGroup actionGroup, int filterId, String messageKey, String contextHelpId) {
        super(Messages.getString("DocumentOutlinePage.action." + messageKey + ".title"), 2);
        this.actionGroup = actionGroup;
        this.filterId = filterId;
        this.messageKey = messageKey;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        this.setChecked(preferences.getBoolean(messageKey, false));
        this.setToolTipText(Messages.getString("DocumentOutlinePage.action." + messageKey + ".tooltip"));
        this.setDescription(Messages.getString("DocumentOutlinePage.action." + messageKey + ".tooltip"));
        if (contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, contextHelpId);
        }
    }

    public int getFilterId() {
        return this.filterId;
    }

    public void run() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        preferences.putBoolean(this.messageKey, this.isChecked());
        this.actionGroup.setFilter(this.filterId, this.isChecked());
    }
}

