/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.ui.internal.PluginImages;
import org.eclipse.vex.ui.internal.outline.OutlineFilter;
import org.eclipse.vex.ui.internal.outline.OutlineFilterAction;

public class OutlineFilterActionGroup
extends ActionGroup {
    private static final String KEY_HIDEINLINEELEMENTS = "hideInlineElements";
    private static final String KEY_SHOWCOMMENTS = "showComments";
    private static final String KEY_SHOWPROCINSTR = "showProcInstr";
    private final OutlineFilterAction[] filterActions;
    private final OutlineFilter filter;
    private StructuredViewer viewer;

    public OutlineFilterActionGroup(StyleSheet styleSheet) {
        ArrayList<OutlineFilterAction> actions = new ArrayList<OutlineFilterAction>(4);
        OutlineFilterAction hideInlineElements = new OutlineFilterAction(this, 1, KEY_HIDEINLINEELEMENTS, null);
        hideInlineElements.setImageDescriptor(PluginImages.DESC_SHOW_INLINE_ELEMENTS);
        actions.add(hideInlineElements);
        OutlineFilterAction showComments = new OutlineFilterAction(this, 2, KEY_SHOWCOMMENTS, null);
        showComments.setImageDescriptor(PluginImages.DESC_XML_COMMENT);
        actions.add(showComments);
        OutlineFilterAction showProcInstr = new OutlineFilterAction(this, 4, KEY_SHOWPROCINSTR, null);
        showProcInstr.setImageDescriptor(PluginImages.DESC_XML_PROC_INSTR);
        actions.add(showProcInstr);
        this.filter = new OutlineFilter(styleSheet);
        OutlineFilterAction[] outlineFilterActionArray = this.filterActions = actions.toArray(new OutlineFilterAction[actions.size()]);
        int n = this.filterActions.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineFilterAction action = outlineFilterActionArray[n2];
            this.setFilter(action.getFilterId(), action.isChecked());
            ++n2;
        }
    }

    public void setFilter(int filterId, boolean isSet) {
        if (isSet) {
            this.filter.addFilter(filterId);
        } else {
            this.filter.removeFilter(filterId);
        }
        if (this.viewer != null) {
            final ISelection currentSelection = this.viewer.getSelection();
            this.viewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    OutlineFilterActionGroup.this.viewer.refresh();
                    OutlineFilterActionGroup.this.viewer.setSelection(currentSelection, true);
                }
            });
            this.viewer.getControl().setRedraw(true);
        }
    }

    public void setViewer(StructuredViewer viewer) {
        this.viewer = viewer;
        viewer.addFilter((ViewerFilter)this.filter);
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.filter.setStyleSheet(styleSheet);
    }

    public boolean isElementFiltered(Object element) {
        return !this.filter.select((Viewer)this.viewer, null, element);
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        OutlineFilterAction[] outlineFilterActionArray = this.filterActions;
        int n = this.filterActions.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineFilterAction action = outlineFilterActionArray[n2];
            toolBarManager.add((IAction)action);
            ++n2;
        }
    }
}

